/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.named;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.named.Named;

final class ImmutableNamed
implements Named {
    private static final ImmutableNamed EMPTY = new ImmutableNamed((Map<String, String>)ImmutableMap.of());
    private final Map<String, String> names;

    public static ImmutableNamed empty() {
        return EMPTY;
    }

    public static ImmutableNamed of(String mappingSchema, String mappingValue) {
        return new ImmutableNamed((Map<String, String>)ImmutableMap.of((Object)mappingSchema, (Object)mappingValue));
    }

    public static ImmutableNamed of(Map<String, String> names) {
        return names.isEmpty() ? ImmutableNamed.empty() : new ImmutableNamed(names);
    }

    private ImmutableNamed(Map<String, String> names) {
        this.names = new LinkedHashMap<String, String>(names);
    }

    @Override
    public Map<String, String> getNames() {
        return this.names;
    }

    @Override
    public @NonNull Named toImmutable() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableNamed)) {
            return false;
        }
        ImmutableNamed that = (ImmutableNamed)o;
        return Objects.equals(this.getNames(), that.getNames());
    }

    public int hashCode() {
        return Objects.hash(this.getNames());
    }

    public String toString() {
        return "ImmutableNamed{names=" + this.names + '}';
    }
}

