/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.metadata.ImmutableMethodReference;
import org.parchmentmc.feather.metadata.MethodReference;
import org.parchmentmc.feather.named.Named;
import org.parchmentmc.feather.named.NamedBuilder;

public final class MethodReferenceBuilder
implements MethodReference {
    protected Named owner = Named.empty();
    protected Named name = Named.empty();
    protected Named descriptor = Named.empty();
    protected Named signature = Named.empty();

    private MethodReferenceBuilder() {
    }

    public static MethodReferenceBuilder create() {
        return new MethodReferenceBuilder();
    }

    public static MethodReferenceBuilder create(MethodReference methodReference) {
        if (methodReference == null) {
            return MethodReferenceBuilder.create();
        }
        return MethodReferenceBuilder.create().withOwner(methodReference.getOwner()).withName(methodReference.getName()).withDescriptor(methodReference.getDescriptor()).withSignature(methodReference.getSignature());
    }

    public MethodReferenceBuilder withOwner(Named owner) {
        this.owner = owner;
        return this;
    }

    public MethodReferenceBuilder withName(Named name) {
        this.name = name;
        return this;
    }

    public MethodReferenceBuilder withDescriptor(Named descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public MethodReferenceBuilder withSignature(Named signature) {
        this.signature = signature;
        return this;
    }

    public MethodReferenceBuilder merge(@Nullable MethodReference source) {
        if (source == null) {
            return this;
        }
        this.owner = NamedBuilder.create(this.owner).merge(source.getOwner()).build();
        this.name = NamedBuilder.create(this.name).merge(source.getName()).build();
        this.descriptor = NamedBuilder.create(this.descriptor).merge(source.getDescriptor()).build();
        this.signature = NamedBuilder.create(this.signature).merge(source.getSignature()).build();
        return this;
    }

    @Override
    public @NonNull Named getOwner() {
        return this.owner;
    }

    @Override
    public @NonNull Named getName() {
        return this.name;
    }

    @Override
    public @NonNull Named getDescriptor() {
        return this.descriptor;
    }

    @Override
    public @NonNull Named getSignature() {
        return this.signature;
    }

    public ImmutableMethodReference build() {
        return new ImmutableMethodReference((Named)this.owner.toImmutable(), (Named)this.name.toImmutable(), (Named)this.descriptor.toImmutable(), (Named)this.signature.toImmutable());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodReference)) {
            return false;
        }
        MethodReference that = (MethodReference)o;
        return Objects.equals(this.getOwner(), that.getOwner()) && this.getName().equals(that.getName()) && this.getDescriptor().equals(that.getDescriptor());
    }

    public int hashCode() {
        return Objects.hash(this.getOwner(), this.getName(), this.getDescriptor(), this.getSignature());
    }

    @Override
    public @NonNull MethodReference toImmutable() {
        return this.build();
    }
}

