/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.FieldMetadata;
import org.parchmentmc.feather.named.Named;

final class ImmutableFieldMetadata
implements FieldMetadata {
    private final Named owner;
    private final Named name;
    private final int securitySpecification;
    private final Named descriptor;
    private final Named signature;

    public ImmutableFieldMetadata(Named owner, Named name, int securitySpecification, Named descriptor, Named signature) {
        this.owner = owner;
        this.name = name;
        this.securitySpecification = securitySpecification;
        this.descriptor = descriptor;
        this.signature = signature;
    }

    @Override
    public @NonNull Named getOwner() {
        return this.owner;
    }

    @Override
    public @NonNull Named getName() {
        return this.name;
    }

    @Override
    public int getSecuritySpecification() {
        return this.securitySpecification;
    }

    @Override
    public @NonNull Named getDescriptor() {
        return this.descriptor;
    }

    @Override
    public @NonNull Named getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldMetadata)) {
            return false;
        }
        FieldMetadata that = (FieldMetadata)o;
        return this.getSecuritySpecification() == that.getSecuritySpecification() && Objects.equals(this.getOwner(), that.getOwner()) && this.getName().equals(that.getName()) && this.getDescriptor().equals(that.getDescriptor()) && Objects.equals(this.getSignature(), that.getSignature());
    }

    public int hashCode() {
        return Objects.hash(this.getOwner(), this.getName(), this.getSecuritySpecification(), this.getDescriptor(), this.getSignature());
    }

    public String toString() {
        return "ImmutableFieldMetadata{owner=" + this.owner + ", name=" + this.name + ", securitySpecification=" + this.securitySpecification + ", descriptor=" + this.descriptor + ", signature=" + this.signature + '}';
    }

    @Override
    public @NonNull FieldMetadata toImmutable() {
        return this;
    }
}

