/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.LinkedHashSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.ClassMetadata;
import org.parchmentmc.feather.metadata.FieldMetadata;
import org.parchmentmc.feather.metadata.MethodMetadata;
import org.parchmentmc.feather.named.Named;

final class ImmutableClassMetadata
implements ClassMetadata {
    private final Named superName;
    private final LinkedHashSet<Named> interfaces;
    private final LinkedHashSet<MethodMetadata> methods;
    private final LinkedHashSet<FieldMetadata> fields;
    private final LinkedHashSet<ClassMetadata> innerClasses;
    private final Named owner;
    private final Named name;
    private final int securitySpecifications;
    private final Named signature;

    public ImmutableClassMetadata(Named superName, LinkedHashSet<Named> interfaces, LinkedHashSet<MethodMetadata> methods, LinkedHashSet<FieldMetadata> fields, LinkedHashSet<ClassMetadata> innerClasses, Named owner, Named name, int securitySpecifications, Named signature) {
        this.superName = superName;
        this.interfaces = new LinkedHashSet<Named>(interfaces);
        this.methods = new LinkedHashSet<MethodMetadata>(methods);
        this.fields = new LinkedHashSet<FieldMetadata>(fields);
        this.innerClasses = new LinkedHashSet<ClassMetadata>(innerClasses);
        this.owner = owner;
        this.name = name;
        this.securitySpecifications = securitySpecifications;
        this.signature = signature;
    }

    public int hashCode() {
        return Objects.hash(this.getSuperName(), this.getInterfaces(), this.getMethods(), this.getFields(), this.getInnerClasses(), this.getOwner(), this.getName(), this.getSecuritySpecification());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassMetadata)) {
            return false;
        }
        ClassMetadata that = (ClassMetadata)o;
        return this.getSecuritySpecification() == that.getSecuritySpecification() && Objects.equals(this.getSuperName(), that.getSuperName()) && this.getInterfaces().equals(that.getInterfaces()) && this.getMethods().equals(that.getMethods()) && this.getFields().equals(that.getFields()) && this.getInnerClasses().equals(that.getInnerClasses()) && Objects.equals(this.getOwner(), that.getOwner()) && this.getName().equals(that.getName());
    }

    @Override
    public int getSecuritySpecification() {
        return this.securitySpecifications;
    }

    @Override
    public @NonNull Named getSuperName() {
        return this.superName;
    }

    @Override
    public @NonNull LinkedHashSet<Named> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public @NonNull LinkedHashSet<MethodMetadata> getMethods() {
        return this.methods;
    }

    @Override
    public @NonNull LinkedHashSet<FieldMetadata> getFields() {
        return this.fields;
    }

    @Override
    public @NonNull LinkedHashSet<ClassMetadata> getInnerClasses() {
        return this.innerClasses;
    }

    @Override
    public @NonNull Named getSignature() {
        return this.signature;
    }

    @Override
    public @NonNull Named getOwner() {
        return this.owner;
    }

    @Override
    public @NonNull Named getName() {
        return this.name;
    }

    public String toString() {
        return "ImmutableClassMetadata{superName=" + this.superName + ", interfaces=" + this.interfaces + ", methods=" + this.methods + ", fields=" + this.fields + ", innerClasses=" + this.innerClasses + ", owner=" + this.owner + ", name=" + this.name + ", securitySpecifications=" + this.securitySpecifications + '}';
    }

    @Override
    public @NonNull ClassMetadata toImmutable() {
        return this;
    }
}

