/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.mapping.MappingDataContainer;
import org.parchmentmc.feather.mapping.MappingUtil;

public class MappingDataBuilder
implements MappingDataContainer {
    private final Set<MutablePackageData> packages = new TreeSet<MappingDataContainer.PackageData>(MappingDataContainer.PackageData.COMPARATOR);
    private final transient Map<String, MutablePackageData> packagesMap = new HashMap<String, MutablePackageData>();
    private final transient Collection<MutablePackageData> packagesView = Collections.unmodifiableSet(this.packages);
    private final Set<MutableClassData> classes = new TreeSet<MappingDataContainer.ClassData>(MappingDataContainer.ClassData.COMPARATOR);
    private final transient Map<String, MutableClassData> classesMap = new HashMap<String, MutableClassData>();
    private final transient Collection<MutableClassData> classesView = Collections.unmodifiableSet(this.classes);

    public static MappingDataBuilder copyOf(MappingDataContainer data) {
        return MappingUtil.copyData(data);
    }

    public Collection<MutablePackageData> getPackages() {
        return this.packagesView;
    }

    @Override
    public @Nullable MutablePackageData getPackage(String packageName) {
        return this.packagesMap.get(packageName);
    }

    public MutablePackageData createPackage(String packageName) {
        MutablePackageData pkg = this.makePackage(packageName);
        this.packagesMap.put(packageName, pkg);
        return pkg;
    }

    public MutablePackageData getOrCreatePackage(String packageName) {
        return this.packagesMap.computeIfAbsent(packageName, this::makePackage);
    }

    private MutablePackageData makePackage(String packageName) {
        MutablePackageData pkg = new MutablePackageData(packageName);
        this.packages.add(pkg);
        return pkg;
    }

    public boolean removePackage(String packageName) {
        MutablePackageData data = this.packagesMap.remove(packageName);
        if (data == null) {
            return false;
        }
        this.packages.remove(data);
        return true;
    }

    public MappingDataBuilder clearPackages() {
        this.packages.clear();
        this.packagesMap.clear();
        return this;
    }

    public Collection<? extends MutableClassData> getClasses() {
        return this.classesView;
    }

    @Override
    public @Nullable MutableClassData getClass(String className) {
        return this.classesMap.get(className);
    }

    public MutableClassData createClass(String className) {
        MutableClassData cls = this.makeClass(className);
        this.classesMap.put(className, cls);
        return cls;
    }

    public MutableClassData getOrCreateClass(String className) {
        return this.classesMap.computeIfAbsent(className, this::makeClass);
    }

    private MutableClassData makeClass(String className) {
        MutableClassData cls = new MutableClassData(className);
        this.classes.add(cls);
        return cls;
    }

    public boolean removeClass(String className) {
        MutableClassData data = this.classesMap.remove(className);
        if (data == null) {
            return false;
        }
        this.classes.remove(data);
        return true;
    }

    public MappingDataBuilder clearClasses() {
        this.classes.clear();
        this.classesMap.clear();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MappingDataContainer)) {
            return false;
        }
        MappingDataContainer builder = (MappingDataContainer)o;
        return this.getPackages().equals(builder.getPackages()) && this.getClasses().equals(builder.getClasses());
    }

    public int hashCode() {
        return Objects.hash(this.getPackages(), this.getClasses());
    }

    public static class MutableParameterData
    implements MappingDataContainer.ParameterData,
    MutableHasJavadoc<MutableParameterData> {
        private final byte index;
        private @Nullable String name = null;
        private @Nullable String javadoc = null;

        MutableParameterData(byte index) {
            this.index = index;
        }

        @Override
        public byte getIndex() {
            return this.index;
        }

        @Override
        public @Nullable String getName() {
            return this.name;
        }

        public MutableParameterData setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public @Nullable String getJavadoc() {
            return this.javadoc;
        }

        public MutableParameterData setJavadoc(@Nullable String javadoc) {
            this.javadoc = javadoc;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.ParameterData)) {
                return false;
            }
            MappingDataContainer.ParameterData that = (MappingDataContainer.ParameterData)o;
            return this.getIndex() == that.getIndex() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getJavadoc(), that.getJavadoc());
        }

        public int hashCode() {
            return Objects.hash(this.getIndex(), this.getName(), this.getJavadoc());
        }

        @Override
        public MutableParameterData addJavadoc(Collection<? extends String> lines) {
            this.javadoc = lines.stream().findFirst().orElse(null);
            return this;
        }

        @Override
        public MutableParameterData clearJavadoc() {
            this.javadoc = null;
            return this;
        }
    }

    public static class MutableMethodData
    implements MappingDataContainer.MethodData,
    MutableHasJavadoc<MutableMethodData> {
        private final String name;
        private final String descriptor;
        private final List<String> javadoc = new ArrayList<String>();
        private final transient List<String> javadocView = Collections.unmodifiableList(this.javadoc);
        private final Set<MutableParameterData> parameters = new TreeSet<MappingDataContainer.ParameterData>(MappingDataContainer.ParameterData.COMPARATOR);
        private final transient Map<Byte, MutableParameterData> parametersMap = new HashMap<Byte, MutableParameterData>();
        private final transient Collection<MutableParameterData> parametersView = Collections.unmodifiableSet(this.parameters);

        MutableMethodData(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public List<String> getJavadoc() {
            return this.javadocView;
        }

        @Override
        public MutableMethodData addJavadoc(Collection<? extends String> lines) {
            this.javadoc.addAll(lines);
            return this;
        }

        @Override
        public MutableMethodData clearJavadoc() {
            this.javadoc.clear();
            return this;
        }

        public Collection<MutableParameterData> getParameters() {
            return this.parametersView;
        }

        @Override
        public @Nullable MutableParameterData getParameter(byte index) {
            return this.parametersMap.get(index);
        }

        public MutableParameterData createParameter(byte index) {
            MutableParameterData param = this.makeParameter(index);
            this.parametersMap.put(index, param);
            return param;
        }

        public MutableParameterData getOrCreateParameter(byte index) {
            return this.parametersMap.computeIfAbsent(index, this::makeParameter);
        }

        private MutableParameterData makeParameter(byte index) {
            MutableParameterData param = new MutableParameterData(index);
            this.parameters.add(param);
            return param;
        }

        public boolean removeParameter(byte index) {
            MutableParameterData data = this.parametersMap.remove(index);
            if (data == null) {
                return false;
            }
            this.parameters.remove(data);
            return true;
        }

        public MutableMethodData clearParameters() {
            this.parameters.clear();
            this.parametersMap.clear();
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.MethodData)) {
                return false;
            }
            MappingDataContainer.MethodData that = (MappingDataContainer.MethodData)o;
            return this.getName().equals(that.getName()) && this.getDescriptor().equals(that.getDescriptor()) && this.getJavadoc().equals(that.getJavadoc()) && this.getParameters().equals(that.getParameters());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getDescriptor(), this.getJavadoc(), this.getParameters());
        }
    }

    public static class MutableFieldData
    implements MappingDataContainer.FieldData,
    MutableHasJavadoc<MutableFieldData> {
        private final String name;
        private final String descriptor;
        private final List<String> javadoc = new ArrayList<String>();
        private final transient List<String> javadocView = Collections.unmodifiableList(this.javadoc);

        MutableFieldData(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public List<String> getJavadoc() {
            return this.javadocView;
        }

        @Override
        public MutableFieldData addJavadoc(Collection<? extends String> lines) {
            this.javadoc.addAll(lines);
            return this;
        }

        @Override
        public MutableFieldData clearJavadoc() {
            this.javadoc.clear();
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.FieldData)) {
                return false;
            }
            MappingDataContainer.FieldData that = (MappingDataContainer.FieldData)o;
            return this.getName().equals(that.getName()) && Objects.equals(this.getDescriptor(), that.getDescriptor()) && this.getJavadoc().equals(that.getJavadoc());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getDescriptor(), this.getJavadoc());
        }
    }

    public static class MutableClassData
    implements MappingDataContainer.ClassData,
    MutableHasJavadoc<MutableClassData> {
        private final String name;
        private final List<String> javadoc = new ArrayList<String>();
        private final transient List<String> javadocView = Collections.unmodifiableList(this.javadoc);
        private final Set<MutableFieldData> fields = new TreeSet<MappingDataContainer.FieldData>(MappingDataContainer.FieldData.COMPARATOR);
        private final transient Map<String, MutableFieldData> fieldsMap = new HashMap<String, MutableFieldData>();
        private final transient Collection<MutableFieldData> fieldsView = Collections.unmodifiableSet(this.fields);
        private final Set<MutableMethodData> methods = new TreeSet<MappingDataContainer.MethodData>(MappingDataContainer.MethodData.COMPARATOR);
        private final transient Map<String, MutableMethodData> methodsMap = new HashMap<String, MutableMethodData>();
        private final transient Collection<MutableMethodData> methodsView = Collections.unmodifiableSet(this.methods);

        MutableClassData(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getJavadoc() {
            return this.javadocView;
        }

        @Override
        public MutableClassData addJavadoc(Collection<? extends String> lines) {
            this.javadoc.addAll(lines);
            return this;
        }

        @Override
        public MutableClassData clearJavadoc() {
            this.javadoc.clear();
            return this;
        }

        public Collection<MutableFieldData> getFields() {
            return this.fieldsView;
        }

        @Override
        public @Nullable MutableFieldData getField(String fieldName) {
            return this.fieldsMap.get(fieldName);
        }

        public MutableFieldData createField(String fieldName, String descriptor) {
            MutableFieldData field = this.makeField(fieldName, descriptor);
            this.fieldsMap.put(fieldName, field);
            return field;
        }

        public MutableFieldData getOrCreateField(String fieldName, String descriptor) {
            return this.fieldsMap.computeIfAbsent(fieldName, name -> this.makeField((String)name, descriptor));
        }

        private MutableFieldData makeField(String fieldName, String descriptor) {
            MutableFieldData field = new MutableFieldData(fieldName, descriptor);
            this.fields.add(field);
            return field;
        }

        public boolean removeField(String fieldName) {
            MutableFieldData data = this.fieldsMap.remove(fieldName);
            if (data == null) {
                return false;
            }
            this.fields.remove(data);
            return true;
        }

        public MutableClassData clearFields() {
            this.fields.clear();
            this.fieldsMap.clear();
            return this;
        }

        public Collection<MutableMethodData> getMethods() {
            return this.methodsView;
        }

        @Override
        public @Nullable MutableMethodData getMethod(String methodName, String descriptor) {
            return this.methodsMap.get(this.key(methodName, descriptor));
        }

        public MutableMethodData createMethod(String methodName, String descriptor) {
            MutableMethodData method = this.makeMethod(methodName, descriptor);
            this.methodsMap.put(this.key(methodName, descriptor), method);
            return method;
        }

        public MutableMethodData getOrCreateMethod(String methodName, String descriptor) {
            return this.methodsMap.computeIfAbsent(this.key(methodName, descriptor), key -> this.makeMethod(methodName, descriptor));
        }

        private MutableMethodData makeMethod(String methodName, String descriptor) {
            MutableMethodData method = new MutableMethodData(methodName, descriptor);
            this.methods.add(method);
            return method;
        }

        public boolean removeMethod(String methodName, String descriptor) {
            MutableMethodData data = this.methodsMap.remove(this.key(methodName, descriptor));
            if (data == null) {
                return false;
            }
            this.methods.remove(data);
            return true;
        }

        public MutableClassData clearMethods() {
            this.methods.clear();
            this.methodsMap.clear();
            return this;
        }

        private String key(String methodName, String descriptor) {
            return methodName + ":" + descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.ClassData)) {
                return false;
            }
            MappingDataContainer.ClassData that = (MappingDataContainer.ClassData)o;
            return Objects.equals(this.getName(), that.getName()) && this.getJavadoc().equals(that.getJavadoc()) && this.getFields().equals(that.getFields()) && this.getMethods().equals(that.getMethods());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getJavadoc(), this.getFields(), this.getMethods());
        }
    }

    public static class MutablePackageData
    implements MappingDataContainer.PackageData,
    MutableHasJavadoc<MutablePackageData> {
        private final String name;
        private final List<String> javadoc = new ArrayList<String>();
        private final transient List<String> javadocView = Collections.unmodifiableList(this.javadoc);

        MutablePackageData(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getJavadoc() {
            return this.javadocView;
        }

        @Override
        public MutablePackageData addJavadoc(Collection<? extends String> lines) {
            this.javadoc.addAll(lines);
            return this;
        }

        @Override
        public MutablePackageData clearJavadoc() {
            this.javadoc.clear();
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.PackageData)) {
                return false;
            }
            MappingDataContainer.PackageData that = (MappingDataContainer.PackageData)o;
            return Objects.equals(this.getName(), that.getName()) && this.getJavadoc().equals(that.getJavadoc());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getJavadoc());
        }
    }

    public static interface MutableHasJavadoc<T> {
        default public T addJavadoc(String ... line) {
            return this.addJavadoc(Arrays.asList(line));
        }

        public T addJavadoc(Collection<? extends String> var1);

        public T clearJavadoc();
    }
}

