/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import kotlinx.io.bytestring.unsafe.UnsafeByteStringOperations;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\t\u001a\u0012\u0010\b\u001a\u00020\u0004*\u00020\t2\u0006\u0010\n\u001a\u00020\u0006\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\f\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"write", "", "Lkotlinx/io/Sink;", "byteString", "Lkotlinx/io/bytestring/ByteString;", "startIndex", "", "endIndex", "readByteString", "Lkotlinx/io/Source;", "byteCount", "indexOf", "", "Lkotlinx/io/Buffer;", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nByteStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 Sinks.kt\nkotlinx/io/SinksKt\n+ 4 UnsafeByteStringOperations.kt\nkotlinx/io/bytestring/unsafe/UnsafeByteStringOperations\n+ 5 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Buffer.kt\nkotlinx/io/BufferKt\n*L\n1#1,167:1\n38#2:168\n374#3:169\n375#3,2:200\n42#4:170\n43#4:199\n42#4:203\n43#4:229\n195#5,28:171\n1#6:202\n659#7,25:204\n*S KotlinDebug\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n*L\n31#1:168\n36#1:169\n36#1:200,2\n39#1:170\n39#1:199\n128#1:203\n128#1:229\n42#1:171,28\n129#1:204,25\n*E\n"})
public final class ByteStringsKt {
    /*
     * WARNING - void declaration
     */
    public static final void write(@NotNull Sink $this$write, @NotNull ByteString byteString, int startIndex, int endIndex) {
        int written;
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        int size$iv = byteString.getSize();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        if (endIndex == startIndex) {
            return;
        }
        Sink $this$writeToInternalBuffer$iv = $this$write;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer buffer = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        int offset = 0;
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] data = byteString.getBackingArrayReference();
        boolean bl2 = false;
        for (offset = startIndex; offset < endIndex; offset += written) {
            void pos;
            void limit;
            written = 0;
            UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
            int minimumCapacity$iv = 1;
            boolean $i$f$writeToTail = false;
            Segment tail$iv = buffer.writableSegment(minimumCapacity$iv);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int n = data$iv.length;
            int n2 = tail$iv.getLimit();
            byte[] segData = data$iv;
            boolean bl3 = false;
            written = Math.min(endIndex - offset, (int)(limit - pos));
            ArraysKt.copyInto((byte[])data, (byte[])segData, (int)pos, (int)offset, (int)(offset + written));
            int bytesWritten$iv = written;
            if (bytesWritten$iv == minimumCapacity$iv) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl4 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!SegmentKt.isEmpty(tail$iv)) continue;
            buffer.recycleTail();
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static /* synthetic */ void write$default(Sink sink, ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteString.getSize();
        }
        ByteStringsKt.write(sink, byteString, n, n2);
    }

    @NotNull
    public static final ByteString readByteString(@NotNull Source $this$readByteString) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteString, (String)"<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray($this$readByteString));
    }

    @NotNull
    public static final ByteString readByteString(@NotNull Source $this$readByteString, int byteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteString, (String)"<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray($this$readByteString, byteCount));
    }

    public static final long indexOf(@NotNull Source $this$indexOf, @NotNull ByteString byteString, long startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        if (!(startIndex >= 0L)) {
            boolean bl = false;
            String string = "startIndex: " + startIndex;
            throw new IllegalArgumentException(string.toString());
        }
        if (ByteStringKt.isEmpty((ByteString)byteString)) {
            return 0L;
        }
        long offset = startIndex;
        while ($this$indexOf.request(offset + (long)byteString.getSize())) {
            long idx = ByteStringsKt.indexOf($this$indexOf.getBuffer(), byteString, offset);
            if (idx < 0L) {
                offset = $this$indexOf.getBuffer().getSize() - (long)byteString.getSize() + 1L;
                continue;
            }
            return idx;
        }
        return -1L;
    }

    public static /* synthetic */ long indexOf$default(Source source, ByteString byteString, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return ByteStringsKt.indexOf(source, byteString, l);
    }

    /*
     * WARNING - void declaration
     */
    public static final long indexOf(@NotNull Buffer $this$indexOf, @NotNull ByteString byteString, long startIndex) {
        long nextOffset$iv;
        Segment s$iv;
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        if (!(startIndex <= $this$indexOf.getSize())) {
            boolean $i$a$-require-ByteStringsKt$indexOf$32 = false;
            String $i$a$-require-ByteStringsKt$indexOf$32 = "startIndex (" + startIndex + ") should not exceed size (" + $this$indexOf.getSize() + ')';
            throw new IllegalArgumentException($i$a$-require-ByteStringsKt$indexOf$32.toString());
        }
        if (ByteStringKt.isEmpty((ByteString)byteString)) {
            return 0L;
        }
        if (startIndex > $this$indexOf.getSize() - (long)byteString.getSize()) {
            return -1L;
        }
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] byteStringData = byteString.getBackingArrayReference();
        boolean bl = false;
        Buffer $this$seek$iv = $this$indexOf;
        boolean $i$f$seek = false;
        if ($this$seek$iv.getHead() == null) {
            void o;
            long l = -1L;
            Segment seg = null;
            boolean bl2 = false;
            if (o == -1L) {
                return -1L;
            }
            Segment segment = seg;
            void offset = o;
            do {
                Intrinsics.checkNotNull(segment);
                int startOffset = Math.max((int)(startIndex - offset), 0);
                int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
                if (idx != -1) {
                    return (long)(offset + (long)idx);
                }
                int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
                int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
                if (idx1 == -1) continue;
                return (long)(offset + (long)idx1);
            } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
            return -1L;
        }
        if ($this$seek$iv.getSize() - startIndex < startIndex) {
            Segment s$iv2;
            long offset$iv = $this$seek$iv.getSize();
            for (s$iv2 = $this$seek$iv.getTail(); s$iv2 != null && offset$iv > startIndex && (offset$iv -= (long)(s$iv2.getLimit() - s$iv2.getPos())) > startIndex; s$iv2 = s$iv2.getPrev()) {
            }
            long o = offset$iv;
            Segment seg = s$iv2;
            boolean bl3 = false;
            if (o == -1L) {
                return -1L;
            }
            Segment segment = seg;
            long offset = o;
            do {
                Intrinsics.checkNotNull((Object)segment);
                int startOffset = Math.max((int)(startIndex - offset), 0);
                int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
                if (idx != -1) {
                    return offset + (long)idx;
                }
                int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
                int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
                if (idx1 == -1) continue;
                return offset + (long)idx1;
            } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
            return -1L;
        }
        long offset$iv = 0L;
        for (s$iv = $this$seek$iv.getHead(); s$iv != null && (nextOffset$iv = offset$iv + (long)(s$iv.getLimit() - s$iv.getPos())) <= startIndex; s$iv = s$iv.getNext()) {
            offset$iv = nextOffset$iv;
        }
        long o = offset$iv;
        Segment seg = s$iv;
        boolean bl4 = false;
        if (o == -1L) {
            return -1L;
        }
        Segment segment = seg;
        long offset = o;
        do {
            Intrinsics.checkNotNull((Object)segment);
            int startOffset = Math.max((int)(startIndex - offset), 0);
            int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
            if (idx != -1) {
                return offset + (long)idx;
            }
            int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
            int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
            if (idx1 == -1) continue;
            return offset + (long)idx1;
        } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
        return -1L;
    }

    public static /* synthetic */ long indexOf$default(Buffer buffer, ByteString byteString, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return ByteStringsKt.indexOf(buffer, byteString, l);
    }
}

