/*
 * Decompiled with CFR 0.152.
 */
package net.peanuuutz.tomlkt.internal.emitter;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.peanuuutz.tomlkt.Toml;
import net.peanuuutz.tomlkt.TomlArray;
import net.peanuuutz.tomlkt.TomlBlockArray;
import net.peanuuutz.tomlkt.TomlElement;
import net.peanuuutz.tomlkt.TomlElementKt;
import net.peanuuutz.tomlkt.TomlInteger;
import net.peanuuutz.tomlkt.TomlLiteral;
import net.peanuuutz.tomlkt.TomlNull;
import net.peanuuutz.tomlkt.TomlTable;
import net.peanuuutz.tomlkt.TomlWriter;
import net.peanuuutz.tomlkt.internal.StringUtilsKt;
import net.peanuuutz.tomlkt.internal.emitter.TomlInlineArrayEmitter;
import net.peanuuutz.tomlkt.internal.emitter.TomlInlineTableEmitter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\"H\u0016J\u000e\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\rH\u0016J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\"2\u0006\u00105\u001a\u000200H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\"2\u0006\u0010<\u001a\u00020=H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001a\u0010\u0019\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006?"}, d2={"Lnet/peanuuutz/tomlkt/internal/emitter/AbstractTomlElementEmitter;", "", "toml", "Lnet/peanuuutz/tomlkt/Toml;", "writer", "Lnet/peanuuutz/tomlkt/TomlWriter;", "<init>", "(Lnet/peanuuutz/tomlkt/Toml;Lnet/peanuuutz/tomlkt/TomlWriter;)V", "getToml", "()Lnet/peanuuutz/tomlkt/Toml;", "getWriter", "()Lnet/peanuuutz/tomlkt/TomlWriter;", "isInline", "", "()Z", "setInline", "(Z)V", "blockArray", "Lnet/peanuuutz/tomlkt/TomlBlockArray;", "getBlockArray", "()Lnet/peanuuutz/tomlkt/TomlBlockArray;", "setBlockArray", "(Lnet/peanuuutz/tomlkt/TomlBlockArray;)V", "isStringMultiline", "setStringMultiline", "isStringLiteral", "setStringLiteral", "integerRepresentation", "Lnet/peanuuutz/tomlkt/TomlInteger;", "getIntegerRepresentation", "()Lnet/peanuuutz/tomlkt/TomlInteger;", "setIntegerRepresentation", "(Lnet/peanuuutz/tomlkt/TomlInteger;)V", "emitElement", "", "element", "Lnet/peanuuutz/tomlkt/TomlElement;", "emitNull", "emitLiteral", "literal", "Lnet/peanuuutz/tomlkt/TomlLiteral;", "emitBoolean", "boolean", "emitInteger", "integer", "", "emitULong", "content", "", "emitFloat", "float", "", "emitString", "string", "emitDateTime", "createArrayEmitter", "array", "Lnet/peanuuutz/tomlkt/TomlArray;", "emitArray", "createTableEmitter", "table", "Lnet/peanuuutz/tomlkt/TomlTable;", "emitTable", "tomlkt"})
@SourceDebugExtension(value={"SMAP\nTomlElementEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlElementEmitter.kt\nnet/peanuuutz/tomlkt/internal/emitter/AbstractTomlElementEmitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,690:1\n1#2:691\n*E\n"})
public abstract class AbstractTomlElementEmitter {
    @NotNull
    private final Toml toml;
    @NotNull
    private final TomlWriter writer;
    private boolean isInline;
    @Nullable
    private TomlBlockArray blockArray;
    private boolean isStringMultiline;
    private boolean isStringLiteral;
    @Nullable
    private TomlInteger integerRepresentation;

    public AbstractTomlElementEmitter(@NotNull Toml toml, @NotNull TomlWriter writer) {
        Intrinsics.checkNotNullParameter((Object)toml, (String)"toml");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.toml = toml;
        this.writer = writer;
    }

    @NotNull
    public final Toml getToml() {
        return this.toml;
    }

    @NotNull
    public final TomlWriter getWriter() {
        return this.writer;
    }

    public final boolean isInline() {
        return this.isInline;
    }

    public final void setInline(boolean bl) {
        this.isInline = bl;
    }

    @Nullable
    public final TomlBlockArray getBlockArray() {
        return this.blockArray;
    }

    public final void setBlockArray(@Nullable TomlBlockArray tomlBlockArray) {
        this.blockArray = tomlBlockArray;
    }

    public final boolean isStringMultiline() {
        return this.isStringMultiline;
    }

    public final void setStringMultiline(boolean bl) {
        this.isStringMultiline = bl;
    }

    public final boolean isStringLiteral() {
        return this.isStringLiteral;
    }

    public final void setStringLiteral(boolean bl) {
        this.isStringLiteral = bl;
    }

    @Nullable
    public final TomlInteger getIntegerRepresentation() {
        return this.integerRepresentation;
    }

    public final void setIntegerRepresentation(@Nullable TomlInteger tomlInteger) {
        this.integerRepresentation = tomlInteger;
    }

    public final void emitElement(@NotNull TomlElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TomlElement tomlElement = element;
        if (tomlElement instanceof TomlNull) {
            this.emitNull();
        } else if (tomlElement instanceof TomlLiteral) {
            this.emitLiteral((TomlLiteral)element);
        } else if (tomlElement instanceof TomlArray) {
            this.createArrayEmitter((TomlArray)element).emitArray((TomlArray)element);
        } else if (tomlElement instanceof TomlTable) {
            this.createTableEmitter((TomlTable)element).emitTable((TomlTable)element);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void emitNull() {
        this.writer.writeNullValue();
    }

    public final void emitLiteral(@NotNull TomlLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        switch (WhenMappings.$EnumSwitchMapping$0[literal.getType().ordinal()]) {
            case 1: {
                this.emitBoolean(TomlElementKt.toBoolean(literal));
                break;
            }
            case 2: {
                Long l = TomlElementKt.toLongOrNull(literal);
                if (l == null) {
                    this.emitULong(literal.getContent());
                    return;
                }
                this.emitInteger(l);
                break;
            }
            case 3: {
                this.emitFloat(TomlElementKt.toDouble(literal));
                break;
            }
            case 4: {
                this.emitString(literal.toString());
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.emitDateTime(literal.getContent());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void emitBoolean(boolean bl) {
        this.writer.writeBooleanValue(bl);
    }

    public void emitInteger(long integer) {
        TomlInteger representation = this.integerRepresentation;
        if (representation == null) {
            TomlWriter.writeIntegerValue$default(this.writer, integer, null, 0, false, 14, null);
            return;
        }
        this.writer.writeIntegerValue(integer, representation.base(), representation.group(), this.toml.getConfig().getUppercaseInteger());
    }

    public void emitULong(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        TomlInteger representation = this.integerRepresentation;
        if (representation == null) {
            this.writer.writeString(content);
            return;
        }
        if (!(representation.group() >= 0)) {
            boolean bl = false;
            String string = "Group size cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
        String string = StringUtilsKt.processIntegerString(content, representation.base(), representation.group(), this.toml.getConfig().getUppercaseInteger());
        this.writer.writeString(string);
    }

    public void emitFloat(double d) {
        this.writer.writeFloatValue(d);
    }

    public void emitString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.writer.writeStringValue(string, this.isStringMultiline, this.isStringLiteral);
    }

    public void emitDateTime(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.writer.writeString(content);
    }

    @NotNull
    public AbstractTomlElementEmitter createArrayEmitter(@NotNull TomlArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return new TomlInlineArrayEmitter(this);
    }

    public void emitArray(@NotNull TomlArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.createArrayEmitter(array).emitArray(array);
    }

    @NotNull
    public AbstractTomlElementEmitter createTableEmitter(@NotNull TomlTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return new TomlInlineTableEmitter(this);
    }

    public void emitTable(@NotNull TomlTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.createTableEmitter(table).emitTable(table);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TomlLiteral.Type.values().length];
            try {
                nArray[TomlLiteral.Type.Boolean.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.Integer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.Float.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.String.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.LocalDateTime.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.OffsetDateTime.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.LocalDate.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TomlLiteral.Type.LocalTime.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

