/*
 * Decompiled with CFR 0.152.
 */
package net.peanuuutz.tomlkt.internal.emitter;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.peanuuutz.tomlkt.TomlArray;
import net.peanuuutz.tomlkt.TomlComment;
import net.peanuuutz.tomlkt.TomlElement;
import net.peanuuutz.tomlkt.TomlInteger;
import net.peanuuutz.tomlkt.TomlLiteralString;
import net.peanuuutz.tomlkt.TomlNull;
import net.peanuuutz.tomlkt.internal.StringUtilsKt;
import net.peanuuutz.tomlkt.internal.emitter.AbstractTomlElementEmitter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/peanuuutz/tomlkt/internal/emitter/TomlBlockArrayEmitter;", "Lnet/peanuuutz/tomlkt/internal/emitter/AbstractTomlElementEmitter;", "delegate", "itemsPerLine", "", "<init>", "(Lnet/peanuuutz/tomlkt/internal/emitter/AbstractTomlElementEmitter;I)V", "emitArray", "", "array", "Lnet/peanuuutz/tomlkt/TomlArray;", "processAnnotations", "annotations", "", "", "emitComment", "comment", "Lnet/peanuuutz/tomlkt/TomlComment;", "tomlkt"})
@SourceDebugExtension(value={"SMAP\nTomlElementEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlElementEmitter.kt\nnet/peanuuutz/tomlkt/internal/emitter/TomlBlockArrayEmitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,690:1\n1872#2,3:691\n1557#2:694\n1628#2,3:695\n*S KotlinDebug\n*F\n+ 1 TomlElementEmitter.kt\nnet/peanuuutz/tomlkt/internal/emitter/TomlBlockArrayEmitter\n*L\n321#1:691,3\n380#1:694\n380#1:695,3\n*E\n"})
final class TomlBlockArrayEmitter
extends AbstractTomlElementEmitter {
    private final int itemsPerLine;

    public TomlBlockArrayEmitter(@NotNull AbstractTomlElementEmitter delegate, int itemsPerLine) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        super(delegate.getToml(), delegate.getWriter());
        this.itemsPerLine = itemsPerLine;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void emitArray(@NotNull TomlArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.getWriter().startArray();
        this.getWriter().writeLineFeed();
        boolean explicitNulls = this.getToml().getConfig().getExplicitNulls();
        String indentation = this.getToml().getConfig().getIndentation-o8wLciY();
        int itemsPerLine = this.itemsPerLine;
        List<List<Annotation>> annotations = array.getAnnotations();
        int lastIndex = array.size() - 1;
        int currentLineItemCount = 0;
        Iterable $this$forEachIndexed$iv = array;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TomlElement tomlElement = (TomlElement)item$iv;
            int index = n;
            boolean bl = false;
            if (element instanceof TomlNull && !explicitNulls) continue;
            List elementAnnotations = (List)CollectionsKt.getOrNull(annotations, (int)index);
            if (elementAnnotations != null) {
                this.processAnnotations(elementAnnotations);
            }
            if (currentLineItemCount == 0) {
                this.getWriter().writeIndentation-bsYWt4I(indentation);
            } else {
                this.getWriter().writeSpace();
            }
            this.emitElement((TomlElement)element);
            this.setStringLiteral(false);
            this.setIntegerRepresentation(null);
            if (index < lastIndex) {
                this.getWriter().writeElementSeparator();
            }
            if (++currentLineItemCount < itemsPerLine) continue;
            this.getWriter().writeLineFeed();
            currentLineItemCount = 0;
        }
        if (currentLineItemCount != 0) {
            this.getWriter().writeLineFeed();
        }
        this.getWriter().endArray();
    }

    private final void processAnnotations(List<? extends Annotation> annotations) {
        TomlComment comment = null;
        for (Annotation annotation : annotations) {
            Annotation annotation2 = annotation;
            if (annotation2 instanceof TomlComment) {
                comment = (TomlComment)annotation;
                continue;
            }
            if (annotation2 instanceof TomlLiteralString) {
                this.setStringLiteral(true);
                continue;
            }
            if (!(annotation2 instanceof TomlInteger)) continue;
            this.setIntegerRepresentation((TomlInteger)annotation);
        }
        if (comment != null && this.itemsPerLine == 1) {
            this.emitComment(comment);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void emitComment(TomlComment comment) {
        void $this$mapTo$iv$iv;
        String indentation = this.getToml().getConfig().getIndentation-o8wLciY();
        Object object = new char[]{'\n'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.trimIndent((String)comment.text()), (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringUtilsKt.escape$default((String)p0, false, 1, null));
        }
        List lines = (List)destination$iv$iv;
        object = lines.iterator();
        while (object.hasNext()) {
            String line = (String)object.next();
            this.getWriter().writeIndentation-bsYWt4I(indentation);
            this.getWriter().startComment();
            this.getWriter().writeSpace();
            this.getWriter().writeString(line);
            this.getWriter().writeLineFeed();
        }
    }
}

