/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NetworkSettingPassthrough {
    private static final Set<String> PROPERTIES = Set.of("socksProxyHost", "socksProxyPort", "socksProxyVersion");
    private static final List<String> PREFIXES = List.of("http.", "https.", "java.net.", "javax.net.ssl.", "jdk.tls.");

    private NetworkSettingPassthrough() {
    }

    public static Map<String, String> getNetworkSystemProperties() {
        Properties properties = System.getProperties();
        return properties.stringPropertyNames().stream().filter(name -> {
            if (PROPERTIES.contains(name)) {
                return true;
            }
            for (String prefix : PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toMap(Function.identity(), properties::getProperty));
    }
}

