/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.vsclc;

import java.util.List;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.ConfigurationGroup;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.InternalConsoleBehaviour;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.LaunchGroupEntry;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.PathLike;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.attribute.RequestType;

public abstract class JavaConfiguration<T extends JavaConfiguration<T>> {
    private final T thiz = this;
    private final ConfigurationGroup parentGroup;
    private String name;
    private LaunchGroupEntry<T> launchGroupEntry;
    private String preTaskName;
    private String postTaskName;
    private InternalConsoleBehaviour internalConsoleOptions;
    private String projectName;
    private List<PathLike> additionalSourcePaths;

    protected JavaConfiguration(ConfigurationGroup parentGroup, int defaultInGroupIndex) {
        this.parentGroup = parentGroup;
        this.launchGroupEntry = new LaunchGroupEntry<T>(this.thiz).withGroupName(parentGroup.getName()).withIndexInGroup(defaultInGroupIndex);
    }

    protected JavaConfiguration() {
        this.parentGroup = null;
    }

    public String getType() {
        return "java";
    }

    public abstract RequestType getRequestType();

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        return this.thiz;
    }

    public LaunchGroupEntry<T> getLaunchGroupEntry() {
        return this.launchGroupEntry;
    }

    public T withLaunchGroupEntry(LaunchGroupEntry<T> launchGroupEntry) {
        this.launchGroupEntry = launchGroupEntry;
        return this.thiz;
    }

    public String getPreTaskName() {
        return this.preTaskName;
    }

    public T withPreTaskName(String preTaskName) {
        this.preTaskName = preTaskName;
        return this.thiz;
    }

    public String getPostTaskName() {
        return this.postTaskName;
    }

    public T withPostTaskName(String postTaskName) {
        this.postTaskName = postTaskName;
        return this.thiz;
    }

    public InternalConsoleBehaviour getInternalConsoleOptions() {
        return this.internalConsoleOptions;
    }

    public T withInternalConsoleOptions(InternalConsoleBehaviour internalConsoleOptions) {
        this.internalConsoleOptions = internalConsoleOptions;
        return this.thiz;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public T withProjectName(String projectName) {
        this.projectName = projectName;
        return this.thiz;
    }

    public List<PathLike> getAdditionalSourcePaths() {
        return this.additionalSourcePaths;
    }

    public T withAdditionalSourcePaths(List<PathLike> additionalSourcePaths) {
        this.additionalSourcePaths = additionalSourcePaths;
        return this.thiz;
    }

    public ConfigurationGroup backToParentGroup() {
        return this.parentGroup;
    }

    protected String validate() {
        if (this.name == null) {
            return "Missing name";
        }
        if (this.projectName == null) {
            return "Missing projectName";
        }
        return null;
    }
}

