/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.vsclc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.AttachConfiguration;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.ConfigurationGroup;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.JavaConfiguration;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.LaunchConfiguration;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.writer.IWriter;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.writer.LaunchJsonV0_2_0;
import net.neoforged.moddev.shadow.net.neoforged.vsclc.writer.WritingMode;

public class BatchedLaunchWriter {
    private final List<JavaConfiguration<?>> configurations = new ArrayList();
    private final List<IWriter.GroupConfiguration> groupConfigurations = new ArrayList<IWriter.GroupConfiguration>();
    private final WritingMode keepCurrentContent;

    public BatchedLaunchWriter(WritingMode keepCurrentContent) {
        this.keepCurrentContent = keepCurrentContent;
    }

    public LaunchConfiguration createLaunchConfiguration() {
        LaunchConfiguration cfg = new LaunchConfiguration();
        this.configurations.add(cfg);
        return cfg;
    }

    public AttachConfiguration createAttachConfiguration() {
        AttachConfiguration cfg = new AttachConfiguration();
        this.configurations.add(cfg);
        return cfg;
    }

    public ConfigurationGroup createGroup(String name, WritingMode groupWritingMode) {
        for (IWriter.GroupConfiguration group : this.groupConfigurations) {
            if (!group.getConfigurationGroup().getName().equals(name)) continue;
            if (group.getWritingMode() != groupWritingMode) {
                throw new IllegalArgumentException(String.format("Group with name \"%s\" is already registered with different writing mode - existing: %s, requested: %s", new Object[]{name, group.getWritingMode(), groupWritingMode}));
            }
            return group.getConfigurationGroup();
        }
        ConfigurationGroup group = new ConfigurationGroup(name);
        this.groupConfigurations.add(new IWriter.GroupConfiguration(group, groupWritingMode));
        return group;
    }

    public void writeToLatestJson(Path projectRoot) throws IOException {
        this.write(LaunchJsonV0_2_0.INSTANCE, projectRoot);
    }

    public void write(IWriter writer, Path projectRoot) throws IOException {
        HashSet nameDeduplicator = new HashSet();
        this.getAllConfigurations().forEach(cfg -> {
            String validationError = cfg.validate();
            if (validationError != null) {
                throw new IllegalStateException(String.format("Invalid configuration with name \"%s\" - %s", cfg.getName(), validationError));
            }
            if (!nameDeduplicator.add(cfg.getName())) {
                throw new IllegalStateException("Duplicate configuration name: " + cfg.getName());
            }
        });
        writer.write(this, projectRoot);
    }

    public Stream<JavaConfiguration<?>> getAllConfigurations() {
        return Stream.concat(this.configurations.stream(), this.groupConfigurations.stream().map(IWriter.GroupConfiguration::getConfigurationGroup).map(ConfigurationGroup::getConfigurations).flatMap(Collection::stream));
    }

    public List<JavaConfiguration<?>> getConfigurations() {
        return this.configurations;
    }

    public List<IWriter.GroupConfiguration> getGroupConfigurations() {
        return this.groupConfigurations;
    }

    public WritingMode getKeepCurrentContent() {
        return this.keepCurrentContent;
    }
}

