/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.nfrtgradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import net.neoforged.nfrtgradle.DownloadedAssetsReference;
import net.neoforged.nfrtgradle.NeoFormRuntimeTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.ApiStatus;

@DisableCachingByDefault(because="Implements its own caching and the output file is system specific")
@ApiStatus.NonExtendable
public abstract class DownloadAssets
extends NeoFormRuntimeTask {
    @Inject
    public DownloadAssets() {
        this.getOutputs().upToDateWhen(DownloadAssets::checkAssetValidity);
    }

    @Input
    @Optional
    public abstract Property<String> getNeoForgeArtifact();

    @Input
    @Optional
    public abstract Property<String> getNeoFormArtifact();

    @Input
    @Optional
    public abstract Property<String> getMinecraftVersion();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getAssetPropertiesFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getAssetJsonFile();

    @TaskAction
    public void downloadAssets() {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "download-assets");
        if (this.getAssetPropertiesFile().isPresent()) {
            Collections.addAll(args, "--write-properties", ((RegularFile)this.getAssetPropertiesFile().get()).getAsFile().getAbsolutePath());
        }
        if (this.getAssetJsonFile().isPresent()) {
            Collections.addAll(args, "--write-json", ((RegularFile)this.getAssetJsonFile().get()).getAsFile().getAbsolutePath());
        }
        if (this.getMinecraftVersion().isPresent()) {
            Collections.addAll(args, "--minecraft-version", (String)this.getMinecraftVersion().get());
        } else if (this.getNeoFormArtifact().isPresent()) {
            Collections.addAll(args, "--neoform", (String)this.getNeoFormArtifact().get());
        } else if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--neoforge", (String)this.getNeoForgeArtifact().get());
        } else {
            throw new GradleException("One of minecraftVersion, neoFormArtifact or neoForgeArtifact must be specified to download assets.");
        }
        this.run(args);
    }

    private static boolean checkAssetValidity(Task task) {
        DownloadAssets downloadTask = (DownloadAssets)task;
        Logger logger = downloadTask.getLogger();
        RegularFileProperty assetReferenceFile = downloadTask.getAssetPropertiesFile();
        if (assetReferenceFile.isPresent()) {
            DownloadedAssetsReference assetReference;
            File file = (File)assetReferenceFile.getAsFile().get();
            if (!file.exists()) {
                logger.info("Asset reference file {} does not exist.", (Object)file);
                return false;
            }
            try {
                assetReference = DownloadedAssetsReference.loadProperties(file);
            }
            catch (Exception e) {
                logger.error("Failed to read downloaded asset index: {}", (Object)file, (Object)e);
                return false;
            }
            return DownloadAssets.validateAssetReference(assetReference, logger);
        }
        return true;
    }

    private static boolean validateAssetReference(DownloadedAssetsReference assetReference, Logger logger) {
        File assetRoot = new File(assetReference.assetsRoot());
        if (!assetRoot.isDirectory()) {
            logger.info("Downloaded assets directory has gone missing: {}", (Object)assetRoot);
            return false;
        }
        File assetIndex = new File(assetRoot, "indexes/" + assetReference.assetIndex() + ".json");
        if (!assetIndex.isFile()) {
            logger.info("Downloaded assets index has gone missing: {}", (Object)assetIndex);
            return false;
        }
        return true;
    }
}

