
package net.neoforged.moddevgradle.internal.generated;

import java.util.List;

public final class MinecraftVersionList {
    private MinecraftVersionList() {}

    /**
     * Released Minecraft Versions as of 2025-07-17T14:04:49.944807297Z from latest to oldest.
     */
    public static final List<String> VERSIONS = List.of("1.21.8", "1.21.8-rc1", "1.21.7", "1.21.7-rc2", "1.21.7-rc1", "1.21.6", "1.21.6-rc1", "1.21.6-pre4", "1.21.6-pre3", "1.21.6-pre2", "1.21.6-pre1", "25w21a", "25w20a", "25w19a", "25w18a", "25w17a", "25w16a", "25w15a", "25w14craftmine", "1.21.5", "1.21.5-rc2", "1.21.5-rc1", "1.21.5-pre3", "1.21.5-pre2", "1.21.5-pre1", "25w10a", "25w09b", "25w09a", "25w08a", "25w07a", "25w06a", "25w05a", "25w04a", "25w03a", "25w02a", "1.21.4", "1.21.4-rc3", "1.21.4-rc2", "1.21.4-rc1", "1.21.4-pre3", "1.21.4-pre2", "1.21.4-pre1", "24w46a", "24w45a", "24w44a", "1.21.3", "1.21.2", "1.21.2-rc2", "1.21.2-rc1", "1.21.2-pre5", "1.21.2-pre4", "1.21.2-pre3", "1.21.2-pre2", "1.21.2-pre1", "24w40a", "24w39a", "24w38a", "24w37a", "24w36a", "24w35a", "24w34a", "24w33a", "1.21.1", "1.21.1-rc1", "1.21", "1.21-rc1", "1.21-pre4", "1.21-pre3", "1.21-pre2", "1.21-pre1", "24w21b", "24w21a", "24w20a", "24w19b", "24w19a", "24w18a", "1.20.6", "1.20.6-rc1", "1.20.5",
            "1.20.5-rc3", "1.20.5-rc2", "1.20.5-rc1", "1.20.5-pre4", "1.20.5-pre3", "1.20.5-pre2", "1.20.5-pre1", "24w14a", "24w14potato", "24w13a", "24w12a", "24w11a", "24w10a", "24w09a", "24w07a", "24w06a", "24w05b", "24w05a", "24w04a", "24w03b", "24w03a", "23w51b", "23w51a", "1.20.4", "1.20.4-rc1", "1.20.3", "1.20.3-rc1", "1.20.3-pre4", "1.20.3-pre3", "1.20.3-pre2", "1.20.3-pre1", "23w46a", "23w45a", "23w44a", "23w43b", "23w43a", "23w42a", "23w41a", "23w40a", "1.20.2", "1.20.2-rc2", "1.20.2-rc1", "1.20.2-pre4", "1.20.2-pre3", "1.20.2-pre2", "1.20.2-pre1", "23w35a", "23w33a", "23w32a", "23w31a", "1.20.1", "1.20.1-rc1", "1.20", "1.20-rc1", "1.20-pre7", "1.20-pre6", "1.20-pre5", "1.20-pre4", "1.20-pre3", "1.20-pre2", "1.20-pre1", "23w18a", "23w17a", "23w16a", "23w14a", "23w13a_or_b", "23w13a", "23w12a", "1.19.4", "1.19.4-rc3", "1.19.4-rc2", "1.19.4-rc1", "1.19.4-pre4", "1.19.4-pre3", "1.19.4-pre2", "1.19.4-pre1", "23w07a", "23w06a", "23w05a", "23w04a", "23w03a", "1.19.3", "1.19.3-rc3",
            "1.19.3-rc2", "1.19.3-rc1", "1.19.3-pre3", "1.19.3-pre2", "1.19.3-pre1", "22w46a", "22w45a", "22w44a", "22w43a", "22w42a", "1.19.2", "1.19.2-rc2", "1.19.2-rc1", "1.19.1", "1.19.1-rc3", "1.19.1-rc2", "1.19.1-pre6", "1.19.1-pre5", "1.19.1-pre4", "1.19.1-pre3", "1.19.1-pre2", "1.19.1-rc1", "1.19.1-pre1", "22w24a", "1.19", "1.19-rc2", "1.19-rc1", "1.19-pre5", "1.19-pre4", "1.19-pre3", "1.19-pre2", "1.19-pre1", "22w19a", "22w18a", "22w17a", "22w16b", "22w16a", "22w15a", "22w14a", "22w13oneblockatatime", "22w13a", "22w12a", "22w11a", "1.18.2", "1.18.2-rc1", "1.18.2-pre3", "1.18.2-pre2", "1.18.2-pre1", "22w07a", "22w06a", "22w05a", "22w03a", "1.18.1", "1.18.1-rc3", "1.18.1-rc2", "1.18.1-rc1", "1.18.1-pre1", "1.18", "1.18-rc4", "1.18-rc3", "1.18-rc2", "1.18-rc1", "1.18-pre8", "1.18-pre7", "1.18-pre6", "1.18-pre5", "1.18-pre4", "1.18-pre3", "1.18-pre2", "1.18-pre1", "21w44a", "21w43a", "21w42a", "21w41a", "21w40a", "21w39a", "21w38a", "21w37a", "1.17.1", "1.17.1-rc2", "1.17.1-rc1",
            "1.17.1-pre3", "1.17.1-pre2", "1.17.1-pre1", "1.17", "1.17-rc2", "1.17-rc1", "1.17-pre5", "1.17-pre4", "1.17-pre3", "1.17-pre2", "1.17-pre1", "21w20a", "21w19a", "21w18a", "21w17a", "21w16a", "21w15a", "21w14a", "21w13a", "21w11a", "21w10a", "21w08b", "21w08a", "21w07a", "21w06a", "21w05b", "21w05a", "21w03a", "1.16.5", "1.16.5-rc1", "20w51a", "20w49a", "20w48a", "20w46a", "20w45a", "1.16.4", "1.16.4-rc1", "1.16.4-pre2", "1.16.4-pre1", "1.16.3", "1.16.3-rc1", "1.16.2", "1.16.2-rc2", "1.16.2-rc1", "1.16.2-pre3", "1.16.2-pre2", "1.16.2-pre1", "20w30a", "20w29a", "20w28a", "20w27a", "1.16.1", "1.16", "1.16-rc1", "1.16-pre8", "1.16-pre7", "1.16-pre6", "1.16-pre5", "1.16-pre4", "1.16-pre3", "1.16-pre2", "1.16-pre1", "20w22a", "20w21a", "20w20b", "20w20a", "20w19a", "20w18a", "20w17a", "20w16a", "20w15a", "20w14a", "20w14infinite", "20w13b", "20w13a", "20w12a", "20w11a", "20w10a", "20w09a", "20w08a", "20w07a", "20w06a", "1.15.2", "1.15.2-pre2", "1.15.2-pre1", "1.15.1",
            "1.15.1-pre1", "1.15", "1.15-pre7", "1.15-pre6", "1.15-pre5", "1.15-pre4", "1.15-pre3", "1.15-pre2", "1.15-pre1", "19w46b", "19w46a", "19w45b", "19w45a", "19w44a", "19w42a", "19w41a", "19w40a", "19w39a", "19w38b", "19w38a", "19w37a", "19w36a", "19w35a", "19w34a", "1.14.4", "1.14.4-pre7", "1.14.4-pre6", "1.14.4-pre5", "1.14.4-pre4", "1.14.4-pre3", "1.14.4-pre2", "1.14.4-pre1", "1.14.3", "1.14.3-pre4", "1.14.3-pre3", "1.14.3-pre2", "1.14.3-pre1", "1.14.2", "1.14.2 Pre-Release 4", "1.14.2 Pre-Release 3", "1.14.2 Pre-Release 2", "1.14.2 Pre-Release 1", "1.14.1", "1.14.1 Pre-Release 2", "1.14.1 Pre-Release 1", "1.14", "1.14 Pre-Release 5", "1.14 Pre-Release 4", "1.14 Pre-Release 3", "1.14 Pre-Release 2", "1.14 Pre-Release 1", "19w14b", "19w14a", "3D Shareware v1.34", "19w13b", "19w13a", "19w12b", "19w12a", "19w11b", "19w11a", "19w09a", "19w08b", "19w08a", "19w07a", "19w06a", "19w05a", "19w04b", "19w04a", "19w03c", "19w03b", "19w03a", "19w02a", "18w50a", "18w49a", "18w48b",
            "18w48a", "18w47b", "18w47a", "18w46a", "18w45a", "18w44a", "18w43c", "18w43b", "18w43a", "1.13.2", "1.13.2-pre2", "1.13.2-pre1", "1.13.1", "1.13.1-pre2", "1.13.1-pre1", "18w33a", "18w32a", "18w31a", "18w30b", "18w30a", "1.13", "1.13-pre10", "1.13-pre9", "1.13-pre8", "1.13-pre7", "1.13-pre6", "1.13-pre5", "1.13-pre4", "1.13-pre3", "1.13-pre2", "1.13-pre1", "18w22c", "18w22b", "18w22a", "18w21b", "18w21a", "18w20c", "18w20b", "18w20a", "18w19b", "18w19a", "18w16a", "18w15a", "18w14b", "18w14a", "18w11a", "18w10d", "18w10c", "18w10b", "18w10a", "18w09a", "18w08b", "18w08a", "18w07c", "18w07b", "18w07a", "18w06a", "18w05a", "18w03b", "18w03a", "18w02a", "18w01a", "17w50a", "17w49b", "17w49a", "17w48a", "17w47b", "17w47a", "17w46a", "17w45b", "17w45a", "17w43b", "17w43a", "1.12.2", "1.12.2-pre2", "1.12.2-pre1", "1.12.1", "1.12.1-pre1", "17w31a", "1.12", "1.12-pre7", "1.12-pre6", "1.12-pre5", "1.12-pre4", "1.12-pre3", "1.12-pre2", "1.12-pre1", "17w18b", "17w18a", "17w17b",
            "17w17a", "17w16b", "17w16a", "17w15a", "17w14a", "17w13b", "17w13a", "17w06a", "1.11.2", "1.11.1", "16w50a", "1.11", "1.11-pre1", "16w44a", "16w43a", "16w42a", "16w41a", "16w40a", "16w39c", "16w39b", "16w39a", "16w38a", "16w36a", "16w35a", "16w33a", "16w32b", "16w32a", "1.10.2", "1.10.1", "1.10", "1.10-pre2", "1.10-pre1", "16w21b", "16w21a", "16w20a", "1.9.4", "1.9.3", "1.9.3-pre3", "1.9.3-pre2", "1.9.3-pre1", "16w15b", "16w15a", "16w14a", "1.RV-Pre1", "1.9.2", "1.9.1", "1.9.1-pre3", "1.9.1-pre2", "1.9.1-pre1", "1.9", "1.9-pre4", "1.9-pre3", "1.9-pre2", "1.9-pre1", "16w07b", "16w07a", "16w06a", "16w05b", "16w05a", "16w04a", "16w03a", "16w02a", "15w51b", "15w51a", "15w50a", "15w49b", "1.8.9", "15w49a", "15w47c", "15w47b", "15w47a", "15w46a", "15w45a", "15w44b", "15w44a", "15w43c", "15w43b", "15w43a", "15w42a", "15w41b", "15w41a", "15w40b", "15w40a", "15w39c", "15w39b", "15w39a", "15w38b", "15w38a", "15w37a", "15w36d", "15w36c", "15w36b", "15w36a", "15w35e", "15w35d",
            "15w35c", "15w35b", "15w35a", "15w34d", "15w34c", "15w34b", "15w34a", "15w33c", "15w33b", "15w33a", "15w32c", "15w32b", "15w32a", "15w31c", "15w31b", "15w31a", "1.8.8", "1.8.7", "1.8.6", "1.8.5", "1.8.4", "15w14a", "1.8.3", "1.8.2", "1.8.2-pre7", "1.8.2-pre6", "1.8.2-pre5", "1.8.2-pre4", "1.8.2-pre3", "1.8.2-pre2", "1.8.2-pre1", "1.8.1", "1.8.1-pre5", "1.8.1-pre4", "1.8.1-pre3", "1.8.1-pre2", "1.8.1-pre1", "1.8", "1.8-pre3", "1.8-pre2", "1.8-pre1", "14w34d", "14w34c", "14w34b", "14w34a", "14w33c", "14w33b", "14w33a", "14w32d", "14w32c", "14w32b", "14w32a", "14w31a", "14w30c", "14w30b", "14w30a", "14w29b", "14w29a", "14w28b", "14w28a", "14w27b", "14w27a", "14w26c", "14w26b", "14w26a", "14w25b", "14w25a", "14w21b", "14w21a", "14w20b", "14w20a", "1.7.10", "1.7.10-pre4", "1.7.10-pre3", "1.7.10-pre2", "1.7.10-pre1", "14w19a", "14w18b", "14w18a", "14w17a", "14w11b", "1.7.9", "1.7.8", "1.7.7", "1.7.6", "14w11a", "1.7.6-pre2", "1.7.6-pre1", "14w10c", "14w10b", "14w10a", "14w08a",
            "1.7.5", "14w07a", "14w06b", "14w06a", "14w05b", "14w05a", "14w04b", "14w04a", "14w03b", "14w03a", "14w02c", "14w02b", "14w02a", "1.7.4", "1.7.3", "13w49a", "13w48b", "13w48a", "13w47e", "13w47d", "13w47c", "13w47b", "13w47a", "1.7.2", "1.7.1", "1.7", "13w43a", "13w42b", "13w42a", "13w41b", "13w41a", "13w39b", "13w39a", "13w38c", "13w38b", "13w38a", "1.6.4", "1.6.3", "13w37b", "13w37a", "13w36b", "13w36a", "1.6.2", "1.6.1", "1.6", "13w26a", "13w25c", "13w25b", "13w25a", "13w24b", "13w24a", "13w23b", "13w23a", "13w22a", "13w21b", "13w21a", "13w19a", "13w18c", "13w18b", "13w18a", "13w17a", "1.5.2", "13w16b", "13w16a", "1.5.1", "1.5", "1.4.7", "1.4.5", "1.4.6", "1.4.4", "1.4.3", "1.4.2", "1.4.1", "1.4", "1.3.2", "1.3.1", "1.3", "1.2.5", "1.2.4", "1.2.3", "1.2.2", "1.2.1", "1.1", "1.0", "b1.8.1", "b1.8", "b1.7.3", "b1.7.2", "b1.7", "b1.6.6", "b1.6.5", "b1.6.4", "b1.6.3", "b1.6.2", "b1.6.1", "b1.6", "b1.5_01", "b1.5", "b1.4_01", "b1.4", "b1.3_01", "b1.3b", "b1.2_02", "b1.2_01",
            "b1.2", "b1.1_02", "b1.1_01", "b1.0.2", "b1.0_01", "b1.0", "a1.2.6", "a1.2.5", "a1.2.4_01", "a1.2.3_04", "a1.2.3_02", "a1.2.3_01", "a1.2.3", "a1.2.2b", "a1.2.2a", "a1.2.1_01", "a1.2.1", "a1.2.0_02", "a1.2.0_01", "a1.2.0", "a1.1.2_01", "a1.1.2", "a1.1.0", "a1.0.17_04", "a1.0.17_02", "a1.0.16", "a1.0.15", "a1.0.14", "a1.0.11", "a1.0.5_01", "a1.0.4", "inf-20100618", "c0.30_01c", "c0.0.13a", "c0.0.13a_03", "c0.0.11a", "rd-161348", "rd-160052", "rd-20090515", "rd-132328", "rd-132211");

    // Indices into VERSIONS sorted by descending length of the version id
    private static final int[] BY_LENGTH = { 201, 367, 368, 369, 370, 372, 373, 375, 376, 377, 378, 379, 382, 18, 315, 816, 7, 8, 9, 10, 22, 23, 24, 39, 40, 41, 49, 50, 51, 52, 53, 82, 83, 84, 85, 87, 106, 107, 108, 109, 121, 122, 123, 124, 144, 151, 152, 153, 154, 164, 165, 166, 178, 179, 180, 181, 182, 184, 207, 208, 209, 218, 243, 244, 245, 280, 281, 287, 288, 289, 326, 327, 329, 354, 355, 356, 357, 358, 359, 360, 362, 363, 364, 365, 414, 415, 417, 418, 478, 479, 481, 661, 662, 663, 664, 819, 823, 1, 3, 4, 6, 20, 21, 36, 37, 38, 47, 48, 63, 77, 79, 80, 81, 103, 105, 119, 120, 130, 148, 149, 150, 161, 162, 163, 173, 174, 176, 177, 183, 206, 215, 216, 217, 241, 242, 272, 279, 283, 285, 286, 425, 531, 532, 533, 540, 541, 542, 613, 614, 615, 616, 617, 618, 619, 621, 622, 623, 624, 625, 675, 676, 808, 809, 66, 67, 68, 69, 133, 134, 135, 136, 137, 138, 139, 189, 190, 191, 192, 193, 224, 225, 226, 227, 228, 229, 230, 231, 249, 250, 251, 252, 253, 297, 298, 299, 300, 301, 302, 303, 304,
            331, 332, 333, 334, 335, 336, 337, 426, 427, 428, 429, 430, 431, 432, 433, 434, 484, 485, 486, 487, 488, 489, 490, 506, 524, 525, 537, 793, 794, 795, 796, 800, 802, 803, 805, 814, 817, 821, 822, 824, 825, 65, 132, 187, 188, 220, 221, 222, 223, 247, 248, 296, 544, 545, 546, 547, 627, 628, 629, 818, 820, 777, 779, 781, 783, 784, 786, 787, 789, 798, 799, 810, 811, 812, 813, 0, 2, 5, 11, 12, 13, 14, 15, 16, 17, 19, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 42, 43, 44, 45, 46, 54, 55, 56, 57, 58, 59, 60, 61, 62, 70, 71, 72, 73, 74, 75, 76, 78, 86, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 104, 110, 111, 112, 113, 114, 115, 116, 117, 118, 125, 126, 127, 128, 129, 140, 141, 142, 143, 145, 146, 147, 155, 156, 157, 158, 159, 160, 167, 168, 169, 170, 171, 172, 175, 185, 194, 195, 196, 197, 198, 199, 200, 202, 203, 204, 205, 210, 211, 212, 213, 214, 232, 233, 234, 235, 236, 237, 238, 239, 240, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267,
            268, 269, 270, 271, 273, 274, 275, 276, 277, 278, 282, 284, 290, 291, 292, 293, 294, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 328, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 361, 366, 371, 380, 381, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 416, 419, 420, 421, 422, 423, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 480, 482, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 526, 527, 528, 534, 535, 536, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 561, 562, 563, 564, 565, 566, 567, 568,
            569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 610, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659, 660, 665, 666, 667, 668, 669, 674, 677, 678, 679, 680, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 696, 697, 698, 699, 700, 701, 702, 703, 707, 708, 709, 710, 711, 712, 713, 714, 715, 716, 719, 720, 721, 722, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 743, 744, 765, 767, 768, 770, 771, 772, 773, 774, 775, 788, 791, 792, 797, 801, 804, 806, 807, 815, 529, 530, 538, 539, 560, 605, 606, 607, 608, 609, 611, 612, 620, 670, 671, 672, 673, 681, 694, 695, 704, 705, 717, 718, 723, 724, 742, 745, 747, 748, 749, 750, 751, 752, 753, 755, 756, 758, 759, 760, 761, 762, 782, 64, 131, 186, 219, 246, 295, 330,
            374, 424, 483, 505, 523, 766, 769, 776, 778, 780, 785, 790, 543, 626, 706, 725, 746, 754, 757, 763, 764 };

    /**
     * Finds the index of the longest matching prefix or -1 if none match.
     * Prefix matches must terminate with one of the given separator characters to be found valid.
     */
    public static int indexOfByPrefix(String version, String separators) {
        for (var versionIdx : BY_LENGTH) {
            var versionText = VERSIONS.get(versionIdx);
            if (version.startsWith(versionText) && (versionText.length() == version.length() || separators.indexOf(version.charAt(versionText.length())) != -1)) {
                return versionIdx;
            }
        }
        return -1;
    }
}
