/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.srgutils.IMappingFile;

public final class IMappingFileUtils {
    private static final List<String> ORDER = Arrays.asList("PK:", "CL:", "FD:", "MD:");

    private IMappingFileUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: IMappingFileUtils. This is a utility class");
    }

    public static IMappingFile load(File file) {
        try {
            return IMappingFile.load((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load mappings file: %s", file.getAbsolutePath()), e);
        }
    }

    public static List<String> writeMappingFile(IMappingFile file, IMappingFile.Format format, boolean reversed) {
        ArrayList<String> lines = new ArrayList<String>();
        Comparator<IMappingFile.INode> sort = reversed ? Comparator.comparing(IMappingFile.INode::getMapped) : Comparator.comparing(IMappingFile.INode::getOriginal);
        file.getPackages().stream().sorted(sort).forEachOrdered(pkg -> {
            lines.add(pkg.write(format, reversed));
            IMappingFileUtils.writeMeta(format, lines, Element.PACKAGE, pkg.getMetadata());
        });
        file.getClasses().stream().sorted(sort).forEachOrdered(cls -> {
            lines.add(cls.write(format, reversed));
            IMappingFileUtils.writeMeta(format, lines, Element.CLASS, cls.getMetadata());
            cls.getFields().stream().sorted(sort).forEachOrdered(fld -> {
                lines.add(fld.write(format, reversed));
                IMappingFileUtils.writeMeta(format, lines, Element.FIELD, fld.getMetadata());
            });
            cls.getMethods().stream().sorted(sort).forEachOrdered(mtd -> {
                lines.add(mtd.write(format, reversed));
                IMappingFileUtils.writeMeta(format, lines, Element.METHOD, mtd.getMetadata());
                mtd.getParameters().stream().sorted((a, b) -> a.getIndex() - b.getIndex()).forEachOrdered(par -> {
                    lines.add(par.write(format, reversed));
                    IMappingFileUtils.writeMeta(format, lines, Element.PARAMETER, par.getMetadata());
                });
            });
        });
        lines.removeIf(Objects::isNull);
        if (!format.isOrdered()) {
            Comparator linesort = format == IMappingFile.Format.SRG || format == IMappingFile.Format.XSRG ? IMappingFileUtils::compareLines : String::compareTo;
            lines.sort(linesort);
        }
        if (format == IMappingFile.Format.TINY1) {
            lines.add(0, "v1\tleft\tright");
        } else if (format == IMappingFile.Format.TINY) {
            lines.add(0, "tiny\t2\t0\tleft\tright");
        } else if (format == IMappingFile.Format.TSRG2) {
            lines.add(0, "tsrg2 left right");
        }
        return lines;
    }

    private static void writeMeta(IMappingFile.Format format, List<String> lines, Element element, Map<String, String> meta) {
        int indent = 0;
        switch (element) {
            case PACKAGE: 
            case CLASS: {
                indent = 1;
                break;
            }
            case FIELD: 
            case METHOD: {
                indent = 2;
                break;
            }
            case PARAMETER: {
                indent = 3;
            }
        }
        switch (format) {
            case CSRG: 
            case PG: 
            case SRG: 
            case TINY1: 
            case TSRG: 
            case XSRG: {
                break;
            }
            case TINY: {
                String comment = meta.get("comment");
                if (comment == null) break;
                char[] prefix = new char[indent];
                Arrays.fill(prefix, '\t');
                lines.add(new String(prefix) + "c\t" + IMappingFileUtils.escapeTinyString(comment));
                break;
            }
            case TSRG2: {
                if (!meta.containsKey("is_static")) break;
                char[] prefix = new char[indent];
                Arrays.fill(prefix, '\t');
                lines.add(new String(prefix) + "static");
            }
        }
    }

    private static String escapeTinyString(String value) {
        return value.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\u0000", "\\0");
    }

    private static int compareLines(String o1, String o2) {
        String[] pt2;
        String[] pt1 = o1.split(" ");
        if (!pt1[0].equals((pt2 = o2.split(" "))[0])) {
            return ORDER.indexOf(pt1[0]) - ORDER.lastIndexOf(pt2[0]);
        }
        if ("PK:".equals(pt1[0])) {
            return o1.compareTo(o2);
        }
        if ("CL:".equals(pt1[0])) {
            return IMappingFileUtils.compareClasses(pt1[1], pt2[1]);
        }
        if ("FD:".equals(pt1[0]) || "MD:".equals(pt1[0])) {
            String[][] y = new String[][]{{pt1[1].substring(0, pt1[1].lastIndexOf(47)), pt1[1].substring(pt1[1].lastIndexOf(47) + 1)}, {pt2[1].substring(0, pt2[1].lastIndexOf(47)), pt2[1].substring(pt2[1].lastIndexOf(47) + 1)}};
            int ret = IMappingFileUtils.compareClasses(y[0][0], y[1][0]);
            if (ret != 0) {
                return ret;
            }
            return y[0][1].compareTo(y[1][1]);
        }
        return o1.compareTo(o2);
    }

    private static int compareClasses(String cls1, String cls2) {
        if (cls1.indexOf(47) > 0 && cls2.indexOf(47) > 0) {
            return cls1.compareTo(cls2);
        }
        String[][] t = new String[][]{cls1.split("\\$"), cls2.split("\\$")};
        int max = Math.min(t[0].length, t[1].length);
        for (int i = 0; i < max; ++i) {
            if (t[0][i].equals(t[1][i])) continue;
            if (t[0][i].length() != t[1][i].length()) {
                return t[0][i].length() - t[1][i].length();
            }
            return t[0][i].compareTo(t[1][i]);
        }
        return Integer.compare(t[0].length, t[1].length);
    }

    static enum Element {
        PACKAGE,
        CLASS,
        FIELD,
        METHOD,
        PARAMETER;

    }
}

