/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.tasks;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ClasspathSerializer
extends DefaultRuntime {
    public ClasspathSerializer() {
        this.getOutputFileName().convention((Object)"classpath.txt");
        this.getTargetFile().convention(this.getOutputDirectory().flatMap(d -> this.getOutputFileName().orElse((Object)"output.lcp").map(arg_0 -> ((Directory)d).file(arg_0))));
        this.getOutput().set((Provider)this.getTargetFile());
        this.setGroup("NeoGradle/Runs");
        this.setDescription("Serializes the classpath of the run to a file.");
    }

    @TaskAction
    public void run() throws Exception {
        File out = this.ensureFileWorkspaceReady(this.getOutput());
        Files.write(out.toPath(), (Iterable<? extends CharSequence>)this.getInputFiles().getAsFileTree().matching(filter -> filter.include(fileTreeElement -> fileTreeElement.isDirectory() || fileTreeElement.getName().endsWith(".jar") || fileTreeElement.getName().endsWith(".zip"))).getFiles().stream().map(File::getAbsolutePath).sorted().collect(Collectors.toCollection(LinkedHashSet::new)), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getInputFiles();

    @Internal
    public abstract RegularFileProperty getTargetFile();
}

