/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.dependency;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runs.type.RunTypeManager;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import org.apache.commons.compress.utils.Lists;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.NotNull;

public class UserDevRunTypeParser
implements RunTypeManager.Parser {
    private final Project project;

    public UserDevRunTypeParser(Project project) {
        this.project = project;
    }

    public Collection<RunType> parse(File file) {
        if (!file.exists()) {
            return Lists.newArrayList();
        }
        try {
            return this.parseInternal(file);
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    @NotNull
    private List<RunType> parseInternal(File file) {
        FileTree fileTree = file.getName().endsWith(".jar") || file.getName().endsWith(".zip") ? this.project.zipTree((Object)file) : this.project.fileTree((Object)file);
        return fileTree.matching(pattern -> pattern.include(new String[]{"config.json"})).getFiles().stream().flatMap(this::parseInternalFile).collect(Collectors.toList());
    }

    private Stream<RunType> parseInternalFile(File file) {
        Stream stream;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            stream = UserdevProfile.get((ObjectFactory)this.project.getObjects(), (InputStream)inputStream).getRunTypes().stream();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Stream.empty();
            }
        }
        inputStream.close();
        return stream;
    }
}

