/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.util;

import net.neoforged.gradle.common.runtime.tasks.SourceInterfaceInjection;
import net.neoforged.gradle.common.util.CommonRuntimeTaskUtils;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.InterfaceInjections;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.TaskProvider;

public class NeoFormAccessTaskAdapterUtils {
    private NeoFormAccessTaskAdapterUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: McpAccessTransformerUtils. This is a utility class");
    }

    public static TaskTreeAdapter createAccessTransformerAdapter(Project project) {
        Minecraft minecraftExtension = (Minecraft)project.getExtensions().getByType(Minecraft.class);
        AccessTransformers accessTransformerFiles = minecraftExtension.getAccessTransformers();
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            if (accessTransformerFiles.getFiles().isEmpty()) {
                return null;
            }
            TaskProvider accessTransformerTask = CommonRuntimeTaskUtils.createSourceAccessTransformer((Definition)definition, (String)"User", (FileTree)accessTransformerFiles.getFiles().getAsFileTree(), (TaskProvider)definition.getListLibrariesTaskProvider(), (FileCollection)definition.getAllDependencies());
            accessTransformerTask.configure(task -> task.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
            accessTransformerTask.configure(task -> task.dependsOn(new Object[]{previousTasksOutput}));
            return accessTransformerTask;
        };
    }

    public static TaskTreeAdapter createInterfaceInjectionAdapter(Project project) {
        Minecraft minecraftExtension = (Minecraft)project.getExtensions().getByType(Minecraft.class);
        InterfaceInjections interfaceInjectionFiles = minecraftExtension.getInterfaceInjections();
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            if (interfaceInjectionFiles.getFiles().isEmpty()) {
                return null;
            }
            TaskProvider interfaceInjectionTask = CommonRuntimeTaskUtils.createSourceInterfaceInjection((Definition)definition, (String)"User", (FileTree)interfaceInjectionFiles.getFiles().getAsFileTree(), (TaskProvider)definition.getListLibrariesTaskProvider(), (FileCollection)definition.getAllDependencies());
            interfaceInjectionTask.configure(task -> task.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
            interfaceInjectionTask.configure(task -> task.dependsOn(new Object[]{previousTasksOutput}));
            definition.additionalCompileSources((FileCollection)project.zipTree((Object)interfaceInjectionTask.flatMap(SourceInterfaceInjection::getStubs)));
            return interfaceInjectionTask;
        };
    }
}

