/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.util.FileDownloadingUtils;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class DownloadFile
extends DefaultRuntime {
    public DownloadFile() {
        this.getDownloadInfo().finalizeValueOnRead();
        this.getIsOffline().convention((Object)this.getProject().getGradle().getStartParameter().isOffline());
    }

    @TaskAction
    public void run() throws Exception {
        if (!this.getDownloadInfo().isPresent()) {
            throw new IllegalStateException("No download info provided");
        }
        FileDownloadingUtils.DownloadInfo info = (FileDownloadingUtils.DownloadInfo)this.getDownloadInfo().get();
        this.doDownloadFrom(info);
    }

    protected void doDownloadFrom(FileDownloadingUtils.DownloadInfo info) throws IOException {
        File outputFile = this.ensureFileWorkspaceReady(this.getOutput());
        FileDownloadingUtils.downloadTo((boolean)((Boolean)this.getIsOffline().get()), (FileDownloadingUtils.DownloadInfo)info, (File)outputFile);
        this.setDidWork(true);
    }

    @Nested
    @Optional
    public abstract Property<FileDownloadingUtils.DownloadInfo> getDownloadInfo();

    @Input
    @Optional
    public abstract Property<Boolean> getIsOffline();
}

