/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class UnpackZip
extends DefaultRuntime {
    public UnpackZip() {
        this.getUnpackingTarget().convention(this.getOutputDirectory().map(dir -> dir.dir("unpacked")));
    }

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    public void execute() throws IOException {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, (ICacheableJob)ICacheableJob.Default.directory((DirectoryProperty)this.getUnpackingTarget(), this::doTask)).execute();
    }

    private void doTask() {
        File output = this.ensureFileWorkspaceReady((File)this.getUnpackingTarget().getAsFile().get());
        CopyingFileTreeVisitor visitor = new CopyingFileTreeVisitor(output);
        this.getInput().getAsFileTree().visit((FileVisitor)visitor);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getInput();

    @OutputDirectory
    public abstract DirectoryProperty getUnpackingTarget();
}

