/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.tasks.RuntimeArgumentsImpl;
import net.neoforged.gradle.common.runtime.tasks.RuntimeMultiArgumentsImpl;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeMultiArguments;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class RecompileSourceJar
extends JavaCompile
implements Runtime {
    private final Property<JavaLanguageVersion> javaVersion;
    private final Provider<JavaToolchainService> javaToolchainService;
    private final RuntimeArguments arguments = (RuntimeArguments)this.getObjectFactory().newInstance(RuntimeArgumentsImpl.class, new Object[]{this.getProviderFactory()});
    private final RuntimeMultiArguments multiArguments = (RuntimeMultiArguments)this.getObjectFactory().newInstance(RuntimeMultiArgumentsImpl.class, new Object[]{this.getProviderFactory()});

    public RecompileSourceJar() {
        this.javaVersion = this.getProject().getObjects().property(JavaLanguageVersion.class);
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class);
        this.javaToolchainService = this.getProviderFactory().provider(() -> service);
        this.getStepsDirectory().convention(this.getRuntimeDirectory().dir("steps"));
        this.getOutputDirectory().convention(this.getStepsDirectory().flatMap(d -> this.getStepName().map(arg_0 -> ((Directory)d).dir(arg_0))));
        this.getOutputFileName().convention(this.getArguments().getOrDefault("outputExtension", this.getProviderFactory().provider(() -> "jar")).map(extension -> String.format("output.%s", extension)));
        this.getJavaVersion().convention((Provider)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion());
        this.getJavaLauncher().convention(this.getJavaToolChain().flatMap(toolChain -> {
            if (!this.getJavaVersion().isPresent()) {
                return toolChain.launcherFor(javaToolchainSpec -> javaToolchainSpec.getLanguageVersion().set((Object)JavaLanguageVersion.of((String)Objects.requireNonNull(Jvm.current().getJavaVersion()).getMajorVersion())));
            }
            return toolChain.launcherFor(spec -> spec.getLanguageVersion().set(this.getJavaVersion()));
        }));
        this.setDescription("Recompiles an already existing decompiled java jar.");
        this.setClasspath((FileCollection)this.getCompileClasspath());
        this.getOptions().setAnnotationProcessorPath((FileCollection)this.getAnnotationProcessorPath());
        this.getOptions().getGeneratedSourceOutputDirectory().convention(this.getOutputDirectory().map(directory -> directory.dir("generated/sources/annotationProcessor")));
        this.getOptions().getHeaderOutputDirectory().convention(this.getOutputDirectory().map(directory -> directory.dir("generated/sources/headers")));
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class);
        this.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
        this.getJavaCompiler().convention(this.getJavaVersion().flatMap(javaVersion -> service.compilerFor(javaToolchainSpec -> javaToolchainSpec.getLanguageVersion().set(javaVersion))));
        this.getDestinationDirectory().set(this.getOutputDirectory().map(directory -> directory.dir("classes")));
        this.getOptions().setWarnings(false);
        this.getOptions().setVerbose(false);
        this.getOptions().setDeprecation(false);
        this.getOptions().setFork(true);
        this.getOptions().setIncremental(true);
        this.getOptions().getIncrementalAfterFailure().set((Object)true);
    }

    @Nested
    public RuntimeArguments getArguments() {
        return this.arguments;
    }

    @Nested
    public RuntimeMultiArguments getMultiArguments() {
        return this.multiArguments;
    }

    public String getGroup() {
        String name = (String)this.getRuntimeName().getOrElse((Object)"unknown");
        return String.format("NeoGradle/Runtime/%s", name);
    }

    @Internal
    public final Provider<JavaToolchainService> getJavaToolChain() {
        return this.javaToolchainService;
    }

    @Nested
    @Optional
    public Property<JavaLanguageVersion> getJavaVersion() {
        return this.javaVersion;
    }

    @Internal
    public abstract ConfigurableFileCollection getAnnotationProcessorPath();

    @Internal
    public abstract ConfigurableFileCollection getCompileClasspath();

    @Inject
    public abstract ObjectFactory getObjectFactory();

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    protected void compile(InputChanges inputs) {
        try {
            ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, (ICacheableJob)ICacheableJob.Default.directory((DirectoryProperty)this.getDestinationDirectory(), () -> super.compile(inputs))).execute();
        }
        catch (IOException e) {
            throw new GradleException("Failed to recompile!", (Throwable)e);
        }
    }
}

