/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.neoform.runtime.tasks.AbstractInjectSource;
import net.neoforged.gradle.neoform.runtime.tasks.ZipEntryFileTreeElement;
import org.apache.commons.io.IOUtils;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.Nullable;

public abstract class InjectFromZipSource
extends AbstractInjectSource {
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getZipFile();

    @Override
    public byte @Nullable [] tryReadFile(String path) throws IOException {
        block11: {
            try (ZipFile zf = new ZipFile((File)this.getZipFile().getAsFile().get());){
                byte[] byArray;
                block12: {
                    ZipEntry entry = zf.getEntry(path);
                    if (entry == null) break block11;
                    InputStream in = zf.getInputStream(entry);
                    try {
                        byArray = IOUtils.toByteArray((InputStream)in);
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return byArray;
            }
        }
        return null;
    }

    @Override
    public void copyTo(ZipOutputStream out) throws IOException {
        Spec spec = this.createFilter().getAsSpec();
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream((File)this.getZipFile().getAsFile().get()));){
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                block10: {
                    if (spec.isSatisfiedBy((Object)new ZipEntryFileTreeElement(entry))) {
                        try {
                            out.putNextEntry(entry);
                            IOUtils.copyLarge((InputStream)zin, (OutputStream)out);
                            out.closeEntry();
                        }
                        catch (ZipException e) {
                            if (!e.getMessage().startsWith("duplicate entry:")) {
                                throw e;
                            }
                            if (entry.isDirectory()) break block10;
                            this.getLogger().warn("Cannot inject duplicate file {}", (Object)entry.getName());
                        }
                    }
                }
                entry = zin.getNextEntry();
            }
        }
    }
}

