/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.specification;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.neoform.configuration.NeoFormConfigConfigurationSpecV2;
import net.neoforged.gradle.dsl.neoform.runtime.specification.NeoFormSpecification;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.util.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoFormRuntimeSpecification
extends CommonRuntimeSpecification
implements NeoFormSpecification {
    private final Provider<File> neoFormArchive;
    private final NeoFormConfigConfigurationSpecV2 config;
    private final FileCollection additionalRecompileDependencies;

    private NeoFormRuntimeSpecification(Project project, String version, Provider<File> neoFormArchive, NeoFormConfigConfigurationSpecV2 config, DistributionType side, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers, FileCollection additionalRecompileDependencies) {
        super(project, "neoForm", version, side, preTaskTypeAdapters, postTypeAdapters, taskCustomizers, NeoFormRuntimeExtension.class);
        this.neoFormArchive = neoFormArchive;
        this.config = config;
        this.additionalRecompileDependencies = additionalRecompileDependencies;
    }

    public NeoFormConfigConfigurationSpecV2 getConfig() {
        return this.config;
    }

    public String getMinecraftVersion() {
        return this.config.getVersion();
    }

    public String getNeoFormVersion() {
        String prefix = this.getMinecraftVersion() + "-";
        if (this.getVersion().startsWith(prefix)) {
            return this.getVersion().substring(prefix.length());
        }
        throw new RuntimeException("NeoForm version " + this.getVersion() + " does not start with Minecraft version" + this.getMinecraftVersion());
    }

    public Provider<File> getNeoFormArchive() {
        return this.neoFormArchive;
    }

    @NotNull
    public FileCollection getAdditionalRecompileDependencies() {
        return this.additionalRecompileDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeoFormRuntimeSpecification)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NeoFormRuntimeSpecification spec = (NeoFormRuntimeSpecification)((Object)o);
        if (!this.neoFormArchive.equals(spec.neoFormArchive)) {
            return false;
        }
        return this.additionalRecompileDependencies.equals(spec.additionalRecompileDependencies);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.neoFormArchive.hashCode();
        result = 31 * result + this.additionalRecompileDependencies.hashCode();
        return result;
    }

    public static abstract class NeoFormUnpack
    implements ValueSource<File, NeoFormUnpackParameters> {
        @Nullable
        public File obtain() {
            RegularFileProperty archive = ((NeoFormUnpackParameters)this.getParameters()).getArchive();
            DirectoryProperty destination = ((NeoFormUnpackParameters)this.getParameters()).getDestination();
            File dest = (File)destination.getAsFile().get();
            if (!dest.exists() && !dest.mkdirs()) {
                throw new GradleException("Failed to create directory " + dest);
            }
            try (ZipFile zipFile = new ZipFile((File)archive.getAsFile().get());){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    File entryDestination = new File(dest, entry.getName());
                    if (entry.isDirectory()) {
                        entryDestination.mkdirs();
                        continue;
                    }
                    entryDestination.getParentFile().mkdirs();
                    InputStream in = zipFile.getInputStream(entry);
                    try (FileOutputStream out = new FileOutputStream(entryDestination);){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
            catch (ZipException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return dest;
        }
    }

    public static interface NeoFormUnpackParameters
    extends ValueSourceParameters {
        public RegularFileProperty getArchive();

        public DirectoryProperty getDestination();
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<NeoFormRuntimeSpecification, Builder>
    implements NeoFormSpecification.Builder<NeoFormRuntimeSpecification, Builder> {
        private Dependency neoFormDependency;
        private FileCollection additionalDependencies;

        private Builder(Project project) {
            super(project);
            this.additionalDependencies = project.getObjects().fileCollection();
            this.withNeoFormVersion("+");
        }

        protected Builder getThis() {
            return this;
        }

        public static Builder from(Project project) {
            return new Builder(project);
        }

        @NotNull
        public Builder withNeoFormVersion(@NotNull String version) {
            this.neoFormDependency = this.project.getDependencies().create((Object)("net.neoforged:neoform:" + version + "@zip"));
            return this.getThis();
        }

        @NotNull
        public Builder withNeoFormDependency(@NotNull Object notation) {
            this.neoFormDependency = this.getProject().getDependencies().create(notation);
            return this.getThis();
        }

        public Builder withAdditionalDependencies(FileCollection files) {
            this.additionalDependencies = this.additionalDependencies.plus(files);
            return this.getThis();
        }

        @NotNull
        public NeoFormRuntimeSpecification build() {
            NeoFormConfigConfigurationSpecV2 config;
            ResolvedArtifact artifact = ToolUtilities.resolveToolArtifact((Project)this.project, (Dependency)this.neoFormDependency);
            File archive = artifact.getFile();
            String effectiveVersion = artifact.getModuleVersion().getId().getVersion();
            try {
                config = (NeoFormConfigConfigurationSpecV2)FileUtils.processFileFromZip((File)archive, (String)"config.json", NeoFormConfigConfigurationSpecV2::get);
            }
            catch (IOException e) {
                throw new GradleException("Failed to read NeoForm config file from version " + effectiveVersion);
            }
            return new NeoFormRuntimeSpecification(this.project, effectiveVersion, (Provider<File>)this.project.getProviders().of(NeoFormUnpack.class, spec -> spec.parameters(p -> {
                p.getArchive().set(archive);
                p.getDestination().set(this.project.getLayout().getBuildDirectory().dir("neoform/" + effectiveVersion));
            })), config, (DistributionType)this.distributionType.get(), (Multimap<String, TaskTreeAdapter>)this.preTaskAdapters, (Multimap<String, TaskTreeAdapter>)this.postTaskAdapters, (Multimap<String, TaskCustomizer<? extends Task>>)this.taskCustomizers, this.additionalDependencies);
        }
    }
}

