/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.eclipse;

import java.io.File;
import net.neoforged.gradle.eclipse.IPropertyDelegate;
import org.gradle.api.Project;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

public class EclipseMetadataReader {
    public static void init(Project project) {
        project.getLogger().debug("Loading Eclipse metadata from project {} for Gradle Version 8.13", (Object)project.getName());
    }

    public static IPropertyDelegate<File> getBaseSourceOutputDirFor(Project project) {
        final EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        return new IPropertyDelegate<File>(){

            public File get() {
                return (File)eclipseModel.getClasspath().getBaseSourceOutputDir().get();
            }

            public void set(File file) {
                eclipseModel.getClasspath().getBaseSourceOutputDir().set((Object)file);
            }

            public void convention(File provider) {
                eclipseModel.getClasspath().getBaseSourceOutputDir().convention((Object)provider);
            }
        };
    }
}

