/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.common.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.specs.Spec;

public class Artifact
implements Comparable<Artifact>,
Serializable,
GroovyObject {
    private final String group;
    private final String name;
    private final String version;
    @Nullable
    private final String classifier;
    @Nullable
    private final String ext;
    @Nullable
    private transient String path;
    @Nullable
    private transient String file;
    @Nullable
    private transient String fullDescriptor;
    @Nullable
    private transient ComparableVersion comparableVersion;
    @Nullable
    private transient Boolean isSnapshot;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Artifact(String group, String name, String version, @Nullable String classifier, @Nullable String ext) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.group = string5 = group;
        this.name = string4 = name;
        this.version = string3 = version;
        this.classifier = string2 = classifier;
        this.ext = string = ext != null ? ext : "jar";
    }

    public static Artifact from(String descriptor) {
        CallSite group = null;
        CallSite name = null;
        CallSite version = null;
        String ext = null;
        CallSite classifier = null;
        CallSite pts = IndyInterface.bootstrap("cast", "()", 0, Iterables.toArray((Iterable)Splitter.on((String)":").split((CharSequence)descriptor), String.class));
        group = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)0));
        name = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)1));
        int last = ((CallSite)pts).length - 1;
        int idx = ((String)BytecodeInterface8.objectArrayGet((Object[])pts, (int)last)).indexOf("@");
        if (idx != -1) {
            ext = ((String)BytecodeInterface8.objectArrayGet((Object[])pts, (int)last)).substring(idx + 1);
            String string = ((String)BytecodeInterface8.objectArrayGet((Object[])pts, (int)last)).substring(0, idx);
            BytecodeInterface8.objectArraySet((Object[])pts, (int)last, (Object)string);
        }
        version = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)2));
        if (((CallSite)pts).length > 3) {
            classifier = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)3));
        }
        return new Artifact((String)((Object)group), (String)((Object)name), (String)((Object)version), (String)((Object)classifier), ext);
    }

    public static Artifact from(String group, String name, String version, @Nullable String classifier, @Nullable String ext) {
        return new Artifact(group, name, version, classifier, ext);
    }

    public static Artifact from(Project project, @Nullable String classifier, @Nullable String ext) {
        return new Artifact(DefaultGroovyMethods.toString((Object)project.getGroup()), project.getName().toString(), DefaultGroovyMethods.toString((Object)project.getVersion()), classifier, ext);
    }

    public static Artifact from(Dependency dependency) {
        if (dependency instanceof ExternalModuleDependency) {
            CallSite externalModuleDependency = IndyInterface.bootstrap("cast", "()", 0, dependency);
            return Artifact.from((ExternalModuleDependency)externalModuleDependency);
        }
        throw (Throwable)new IllegalArgumentException(String.format("Dependency: %s is not an external Artifact that can be referenced.", dependency));
    }

    public static Artifact from(ExternalModuleDependency dependency) {
        if (dependency.getArtifacts().isEmpty()) {
            return new Artifact(dependency.getGroup() == null ? "" : dependency.getGroup(), dependency.getName(), dependency.getVersion() == null ? "" : dependency.getVersion(), null, null);
        }
        CallSite artifact = IndyInterface.bootstrap("cast", "()", 0, dependency.getArtifacts().iterator().next());
        return new Artifact(dependency.getGroup() == null ? "" : dependency.getGroup(), dependency.getName(), dependency.getVersion() == null ? "" : dependency.getVersion(), artifact.getClassifier(), artifact.getExtension());
    }

    public static Artifact from(ResolvedArtifact dependency) {
        return new Artifact(dependency.getModuleVersion().getId().getGroup() == null ? "" : dependency.getModuleVersion().getId().getGroup(), dependency.getModuleVersion().getId().getName(), dependency.getModuleVersion().getId().getVersion() == null ? "" : dependency.getModuleVersion().getId().getVersion(), dependency.getClassifier(), dependency.getExtension());
    }

    public String getLocalPath() {
        return this.getPath().replace(((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "/", Character.class))).charValue(), File.separatorChar);
    }

    public String getDescriptor() {
        if (this.fullDescriptor == null) {
            String string;
            StringBuilder buf = new StringBuilder();
            buf.append(this.group).append(":").append(this.name).append(":").append(this.version);
            if (this.classifier != null) {
                buf.append(":").append(this.classifier);
            }
            if (this.ext != null && ScriptBytecodeAdapter.compareNotEqual((Object)"jar", (Object)this.ext)) {
                buf.append("@").append(this.ext);
            }
            this.fullDescriptor = string = buf.toString();
        }
        return this.fullDescriptor;
    }

    public String getPath() {
        if (this.path == null) {
            String string;
            this.path = string = String.join((CharSequence)"/", this.group.replace(".", "/"), this.name, this.version, this.getFilename());
        }
        return this.path;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getExtension() {
        return this.ext;
    }

    public String getFilename() {
        if (this.file == null) {
            String string;
            String file = null;
            file = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)this.name, (CharSequence)"-"), (CharSequence)this.version);
            if (this.classifier != null) {
                file = StringGroovyMethods.plus((String)file, (CharSequence)StringGroovyMethods.plus((String)"-", (CharSequence)this.classifier));
            }
            file = StringGroovyMethods.plus((String)file, (CharSequence)StringGroovyMethods.plus((String)".", (CharSequence)this.ext));
            this.file = string = file;
        }
        return this.file;
    }

    public boolean isSnapshot() {
        if (this.isSnapshot == null) {
            boolean bl = this.version.toLowerCase(Locale.ROOT).endsWith("-snapshot");
            this.isSnapshot = bl;
        }
        return DefaultTypeTransformation.booleanUnbox((Object)this.isSnapshot);
    }

    public Artifact withVersion(String version) {
        return Artifact.from(this.group, this.name, version, this.classifier, this.ext);
    }

    public String toString() {
        return this.getDescriptor();
    }

    public int hashCode() {
        return this.getDescriptor().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Artifact && this.getDescriptor().equals(((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, o))).getDescriptor());
    }

    public Spec<Dependency> asDependencySpec() {
        public final class _asDependencySpec_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _asDependencySpec_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Dependency dep) {
                return ((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getGroup().equals(dep.getGroup()) && ((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getName().equals(dep.getName()) && ((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getVersion().equals(dep.getVersion());
            }

            @Generated
            public Boolean call(Dependency dep) {
                return this.doCall(dep);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _asDependencySpec_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, new _asDependencySpec_closure1(this, this));
    }

    public Predicate<Dependency> asDependencyMatcher() {
        public final class _asDependencyMatcher_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _asDependencyMatcher_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Dependency dep) {
                return ((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getGroup().equals(dep.getGroup()) && ((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getName().equals(dep.getName()) && ((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getVersion().equals(dep.getVersion());
            }

            @Generated
            public Boolean call(Dependency dep) {
                return this.doCall(dep);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _asDependencyMatcher_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, new _asDependencyMatcher_closure2(this, this));
    }

    public Predicate<ResolvedArtifact> asArtifactMatcher() {
        public final class _asArtifactMatcher_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _asArtifactMatcher_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(ResolvedArtifact art) {
                String theirClassifier = null;
                theirClassifier = art.getClassifier() == null ? "" : art.getClassifier();
                String theirExt = null;
                theirExt = art.getExtension().isEmpty() ? "jar" : art.getExtension();
                return (((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getClassifier() == null || ((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getClassifier().equals(theirClassifier)) && (((Artifact)this.getThisObject()).ext == null || ((Artifact)this.getThisObject()).ext.equals(theirExt));
            }

            @Generated
            public Boolean call(ResolvedArtifact art) {
                return this.doCall(art);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _asArtifactMatcher_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, new _asArtifactMatcher_closure3(this, this));
    }

    public ComparableVersion getComparableVersion() {
        if (this.comparableVersion == null) {
            ComparableVersion comparableVersion;
            this.comparableVersion = comparableVersion = new ComparableVersion(this.version);
        }
        return this.comparableVersion;
    }

    @Override
    public int compareTo(Artifact o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.group), (Comparable)((Object)o.getGroup())).compare((Comparable)((Object)this.name), (Comparable)((Object)o.getName())).compare((Comparable)this.getComparableVersion(), (Comparable)o.getComparableVersion()).compare((Object)this.classifier, (Object)o.getClassifier(), Comparator.nullsFirst(Comparator.naturalOrder())).compare((Object)this.ext, (Object)o.ext, Comparator.nullsFirst(Comparator.naturalOrder())).result();
    }

    public Dependency toDependency(Project project) {
        return project.getDependencies().create((Object)this.getDescriptor());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Artifact.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ String pfaccess$0(Artifact $that) {
        return $that.group;
    }

    public static /* synthetic */ String pfaccess$1(Artifact $that) {
        return $that.name;
    }

    public static /* synthetic */ String pfaccess$2(Artifact $that) {
        return $that.version;
    }

    public static /* synthetic */ String pfaccess$3(Artifact $that) {
        return $that.classifier;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

