/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.common.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.util.List;
import java.util.Map;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;

public abstract class GradleGsonTypeAdapter<T>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    protected static <T> void deserializeProperty(JsonObject json, JsonDeserializationContext context, Property<T> property, String key, T defaultValue) {
        JsonElement value = json.getAsJsonObject().get(key);
        if (value != null) {
            property.set(context.deserialize(value, defaultValue.getClass()));
        } else {
            property.set(defaultValue);
        }
    }

    protected static <T> void deserializeProperty(JsonObject json, JsonDeserializationContext context, ListProperty<T> property, String key, List<T> defaultValue) {
        JsonElement value = json.getAsJsonObject().get(key);
        if (value != null) {
            property.set((Iterable)((List)context.deserialize(value, defaultValue.getClass())));
        } else {
            property.set(defaultValue);
        }
    }

    protected static <T extends Map<? extends K, ? extends V>, K, V> void deserializeProperty(JsonObject json, JsonDeserializationContext context, MapProperty<K, V> property, String key, T defaultValue) {
        JsonElement value = json.getAsJsonObject().get(key);
        if (value != null) {
            property.set((Map)context.deserialize(value, defaultValue.getClass()));
        } else {
            property.set(defaultValue);
        }
    }

    protected <E> void serializeProperty(JsonObject json, JsonSerializationContext context, Property<E> property, String key) {
        json.add(key, context.serialize(property.get()));
    }

    protected <E> void serializeProperty(JsonObject json, JsonSerializationContext context, ListProperty<E> property, String key) {
        json.add(key, context.serialize(property.get()));
    }

    protected <K, V> void serializeProperty(JsonObject json, JsonSerializationContext context, MapProperty<K, V> property, String key) {
        json.add(key, context.serialize(property.get()));
    }
}

