/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.common.runtime.tasks.tree;

import java.util.function.Consumer;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import org.gradle.api.Task;

public final class TaskCustomizer<T extends Task> {
    private final Class<T> taskClass;
    private final Consumer<T> taskCustomizer;

    public TaskCustomizer(Class<T> taskClass, Consumer<T> taskCustomizer) {
        this.taskClass = taskClass;
        this.taskCustomizer = taskCustomizer;
    }

    public Class<T> getTaskClass() {
        return this.taskClass;
    }

    public Consumer<T> getTaskCustomizer() {
        return this.taskCustomizer;
    }

    public void apply(Runtime task) {
        if (!this.taskClass.isInstance(task)) {
            throw new IllegalArgumentException("Customization for step " + task.getStepName() + " requires task type " + this.taskClass + " but actual task is " + task.getClass());
        }
        this.taskCustomizer.accept((Task)this.taskClass.cast(task));
    }
}

