/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.jobs;

import com.machinezoo.noexception.throwing.ThrowingFunction;
import com.machinezoo.noexception.throwing.ThrowingSupplier;
import java.io.File;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;

public interface ICacheableJob<I, O> {
    default public String name() {
        return "default";
    }

    public File output();

    public O execute(I var1) throws Throwable;

    public boolean createsDirectory();

    public boolean mergesDirectory();

    public record Staged<I, O>(String name, File output, ThrowingFunction<I, O> job) implements ICacheableJob<I, O>
    {
        public static <U, V> Staged<U, V> file(String name, RegularFileProperty output, ThrowingFunction<U, V> execute) {
            return new Staged<U, V>(name, ((RegularFile)output.get()).getAsFile(), execute);
        }

        @Override
        public O execute(I input) throws Throwable {
            return (O)this.job.apply(input);
        }

        @Override
        public boolean createsDirectory() {
            return false;
        }

        @Override
        public boolean mergesDirectory() {
            return false;
        }
    }

    public record Initial<V>(String name, File output, boolean createsDirectory, boolean mergesDirectory, ThrowingSupplier<V> execute) implements ICacheableJob<Void, V>
    {
        public static <V> Initial<V> file(String name, RegularFileProperty output, ThrowingSupplier<V> execute) {
            return new Initial<V>(name, ((RegularFile)output.get()).getAsFile(), false, false, execute);
        }

        public static <V> Initial<V> directory(String name, Provider<Directory> output, ThrowingSupplier<V> execute) {
            return new Initial<V>(name, ((Directory)output.get()).getAsFile(), true, false, execute);
        }

        public static <V> Initial<V> merging(String name, Provider<Directory> output, ThrowingSupplier<V> execute) {
            return new Initial<V>(name, ((Directory)output.get()).getAsFile(), true, true, execute);
        }

        @Override
        public V execute(Void input) throws Throwable {
            return (V)this.execute().get();
        }
    }

    public record Default(File output, boolean createsDirectory, boolean mergesDirectory, ThrowingRunnable execute) implements ICacheableJob<Void, Void>
    {
        public static Default file(RegularFileProperty output, ThrowingRunnable execute) {
            return new Default(((RegularFile)output.get()).getAsFile(), false, false, execute);
        }

        public static Default directory(DirectoryProperty output, ThrowingRunnable execute) {
            return new Default(((Directory)output.get()).getAsFile(), true, false, execute);
        }

        public static Default merging(DirectoryProperty output, boolean merges, ThrowingRunnable execute) {
            return new Default(((Directory)output.get()).getAsFile(), true, true, execute);
        }

        @Override
        public Void execute(Void input) throws Exception {
            this.execute().run();
            return null;
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

