/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.hasher;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.stream.Stream;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;
import net.neoforged.gradle.common.util.hash.HashCode;
import net.neoforged.gradle.common.util.hash.HashFunction;
import net.neoforged.gradle.common.util.hash.Hasher;
import net.neoforged.gradle.common.util.hash.Hashing;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskInputs;

public final class TaskHasher {
    private final HashFunction hashFunction = Hashing.sha256();
    private final Hasher hasher = this.hashFunction.newHasher();
    private final Task task;
    private final CacheLogger logger;

    public TaskHasher(Task task, CacheLogger logger) {
        this.task = task;
        this.logger = logger;
    }

    public void hash() throws IOException {
        this.logger.debug("Hashing task: " + this.task.getPath());
        this.hasher.putString(this.task.getClass().getName());
        TaskInputs taskInputs = this.task.getInputs();
        this.hash(taskInputs);
    }

    private void hash(TaskInputs inputs) throws IOException {
        this.logger.debug("Hashing task inputs: " + this.task.getPath());
        inputs.getProperties().forEach((key, value) -> {
            this.logger.debug("Hashing task input property: " + key);
            this.hasher.putString((CharSequence)key);
            this.logger.debug("Hashing task input property value: " + String.valueOf(value));
            this.hasher.put(value, false);
        });
        HashSet<File> inputFiles = new HashSet<File>();
        for (File file : inputs.getFiles()) {
            Stream<Path> pathStream = Files.walk(file.toPath(), new FileVisitOption[0]);
            try {
                for (Path path : pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList()) {
                    inputFiles.add(path.toFile());
                }
            }
            finally {
                if (pathStream == null) continue;
                pathStream.close();
            }
        }
        ArrayList<File> files = new ArrayList<File>(inputFiles);
        files.sort(Comparator.comparing(File::getAbsolutePath));
        for (File file : files) {
            this.logger.debug("Hashing task input file: " + file.getAbsolutePath());
            this.hasher.putString(file.getName());
            HashCode code = this.hashFunction.hashFile(file);
            this.logger.debug("Hashing task input file hash: " + String.valueOf(code));
            this.hasher.putHash(code);
        }
    }

    public HashCode create() throws IOException {
        this.hash();
        return this.hasher.hash();
    }
}

