/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.tasks.specifications.ExecuteSpecification;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class SourceAccessTransformer
extends DefaultExecute {
    public SourceAccessTransformer() {
        this.setDescription("Runs the access transformer on the decompiled sources.");
        this.getExecutingJar().set(ToolUtilities.resolveTool(this.getProject(), (String)((Subsystems)this.getProject().getExtensions().getByType(Subsystems.class)).getTools().getJST().get()));
        this.getRuntimeProgramArguments().convention(this.getInputFile().map(inputFile -> {
            ArrayList args = Lists.newArrayList();
            File outputFile = this.ensureFileWorkspaceReady(this.getOutput());
            args.add("--enable-accesstransformers");
            this.getTransformers().forEach(f -> {
                args.add("--access-transformer");
                args.add(f.getAbsolutePath());
            });
            args.add("--libraries-list=" + ((RegularFile)this.getLibraries().get()).getAsFile().getAbsolutePath());
            StringBuilder builder = new StringBuilder();
            this.getClasspath().forEach(f -> {
                if (!builder.isEmpty()) {
                    builder.append(File.pathSeparator);
                }
                builder.append(f.getAbsolutePath());
            });
            args.add("--classpath=" + String.valueOf(builder));
            args.add(inputFile.getAsFile().getAbsolutePath());
            args.add(outputFile.getAbsolutePath());
            return args;
        }));
        this.getJavaVersion().convention((Provider)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion());
        this.getTransformers().finalizeValueOnRead();
        this.getLogLevel().set((Object)ExecuteSpecification.LogLevel.DISABLED);
    }

    public void doExecute() throws Exception {
        if (this.getTransformers().isEmpty()) {
            File output = this.ensureFileWorkspaceReady(this.getOutput());
            FileUtils.copyFile((File)((RegularFile)this.getInputFile().get()).getAsFile(), (File)output);
        }
        super.doExecute();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInputFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getLibraries();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getClasspath();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getTransformers();
}

