/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.gdi.annotations.DSLProperty;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class NoopRuntime
extends DefaultRuntime {
    @TaskAction
    void doProvide() throws Exception {
        Path output = this.ensureFileWorkspaceReady(this.getOutput()).toPath();
        Path source = ((RegularFile)this.getInput().get()).getAsFile().toPath();
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IllegalStateException("Source file does not exist: " + String.valueOf(source));
        }
        Files.copy(source, output, new CopyOption[0]);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @DSLProperty
    public abstract RegularFileProperty getInput();
}

