/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.srgutils.IMappingFile;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.dsl.common.tasks.NeoGradleBase;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.util.FileUtils;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;

@CacheableTask
public abstract class GenerateExtraJar
extends NeoGradleBase
implements WithOutput,
WithWorkspace {
    public GenerateExtraJar() {
        this.getOutputFileName().set((Object)"client-extra.jar");
    }

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    public void run() throws Throwable {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, ICacheableJob.Default.file(this.getOutput(), this::doRun)).execute();
    }

    private void doRun() throws Exception {
        File outputJar = this.ensureFileWorkspaceReady(this.getOutput());
        IMappingFile mappings = IMappingFile.load((File)((File)this.getMappings().getAsFile().get())).reverse();
        try (JarFile clientZip = new JarFile((File)this.getOriginalJar().getAsFile().get());
             JarFile serverZip = new JarFile((File)this.getServerJar().getAsFile().get());){
            Set<String> clientFiles = this.getFileIndex(clientZip);
            clientFiles.remove("META-INF/MANIFEST.MF");
            Set<String> serverFiles = this.getFileIndex(serverZip);
            serverFiles.remove("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().putValue("Minecraft-Dists", "server client");
            GenerateExtraJar.addSourceDistEntries(clientFiles, serverFiles, "client", mappings, manifest);
            GenerateExtraJar.addSourceDistEntries(serverFiles, clientFiles, "server", mappings, manifest);
            try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputJar)));){
                zos.putNextEntry(FileUtils.getStableEntry((String)"META-INF/MANIFEST.MF"));
                manifest.write(zos);
                zos.closeEntry();
                Enumeration<JarEntry> clientEntries = clientZip.entries();
                while (clientEntries.hasMoreElements()) {
                    JarEntry clientEntry = clientEntries.nextElement();
                    if (!GenerateExtraJar.isResourceEntry(clientEntry)) continue;
                    zos.putNextEntry(clientEntry);
                    try (InputStream clientIn = clientZip.getInputStream(clientEntry);){
                        clientIn.transferTo(zos);
                    }
                    zos.closeEntry();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addSourceDistEntries(Set<String> distFiles, Set<String> otherDistFiles, String dist, IMappingFile mappings, Manifest manifest) {
        for (String string : distFiles) {
            void var6_6;
            if (otherDistFiles.contains(string)) continue;
            Attributes fileAttr = new Attributes(1);
            fileAttr.putValue("Minecraft-Dist", dist);
            if (mappings != null && string.endsWith(".class")) {
                String string2 = mappings.remapClass(string.substring(0, string.length() - ".class".length())) + ".class";
            }
            manifest.getEntries().put((String)var6_6, fileAttr);
        }
    }

    private Set<String> getFileIndex(ZipFile zipFile) throws IOException {
        String embeddedVersionPath = GenerateExtraJar.readEmbeddedVersionPath(zipFile);
        if (embeddedVersionPath != null) {
            ZipEntry versionJarEntry = zipFile.getEntry(embeddedVersionPath);
            if (versionJarEntry == null) {
                throw new IOException("version list in jar file " + String.valueOf(zipFile) + " refers to missing entry " + embeddedVersionPath);
            }
            File unbundledFile = new File(this.getTemporaryDir(), "unpacked.jar");
            try (InputStream in = zipFile.getInputStream(versionJarEntry);){
                Files.copy(in, unbundledFile.toPath(), new CopyOption[0]);
            }
            try (ZipFile zf = new ZipFile(unbundledFile);){
                Set<String> set = this.getFileIndex(zf);
                return set;
            }
        }
        HashSet<String> result = new HashSet<String>(zipFile.size());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            result.add(entry.getName());
        }
        return result;
    }

    private static boolean isResourceEntry(JarEntry entry) {
        return !entry.getName().endsWith(".class") && !entry.isDirectory() && !entry.getName().equals("META-INF/MANIFEST.MF") && !GenerateExtraJar.isSignatureFile(entry.getName());
    }

    private static boolean isSignatureFile(String name) {
        return name.startsWith("META-INF/") && (name.endsWith(".SF") || name.endsWith(".RSA") || name.endsWith(".EC") || name.endsWith(".DSA"));
    }

    @Nullable
    private static String readEmbeddedVersionPath(ZipFile zipFile) throws IOException {
        ZipEntry entry = zipFile.getEntry("META-INF/versions.list");
        if (entry == null) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        try (InputStream in = zipFile.getInputStream(entry);){
            for (String line : new String(in.readAllBytes()).split("\n")) {
                if (line.isBlank()) continue;
                String[] pts = line.split("\t");
                if (pts.length != 3) {
                    throw new IOException("Invalid file list line: " + line + " in " + String.valueOf(zipFile));
                }
                entries.add(pts[2]);
            }
        }
        if (entries.isEmpty()) {
            return null;
        }
        if (entries.size() == 1) {
            return "META-INF/versions/" + (String)entries.get(0);
        }
        throw new IOException("Version file list contains more than one entry in " + String.valueOf(zipFile));
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getOriginalJar();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getServerJar();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getMappings();
}

