/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import org.gradle.api.artifacts.Dependency;

public abstract class RuntimesExtension {
    private final List<CommonRuntimeExtension<?, ?, ?>> runtimeExtensions = new ArrayList();

    public void add(CommonRuntimeExtension<?, ?, ?> runtimeExtension) {
        this.runtimeExtensions.add(runtimeExtension);
    }

    public Collection<? extends CommonRuntimeDefinition<?>> getAllDefinitions() {
        ArrayList definitions = new ArrayList();
        for (CommonRuntimeExtension<?, ?, ?> runtimeExtension : this.runtimeExtensions) {
            definitions.addAll(runtimeExtension.definitions.values());
        }
        return definitions;
    }

    public Map<String, Dependency> getAllDependencies() {
        HashMap<String, Dependency> dependencies = new HashMap<String, Dependency>();
        for (CommonRuntimeExtension<?, ?, ?> runtimeExtension : this.runtimeExtensions) {
            dependencies.putAll(runtimeExtension.dependencies);
        }
        return dependencies;
    }

    public boolean definitionExists(String identifier) {
        for (CommonRuntimeExtension<?, ?, ?> runtimeExtension : this.runtimeExtensions) {
            if (!runtimeExtension.definitions.containsKey(identifier)) continue;
            return true;
        }
        return false;
    }

    public <T extends CommonRuntimeDefinition<?>> T findDefinitionByNameOrIdentifier(String name) {
        for (CommonRuntimeExtension<?, ?, ?> runtimeExtension : this.runtimeExtensions) {
            Definition definition = runtimeExtension.findByNameOrIdentifier(name);
            if (definition == null) continue;
            return (T)definition;
        }
        return null;
    }
}

