/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.subsystems;

import javax.inject.Inject;
import net.minecraftforge.gdi.BaseDSLElement;
import net.neoforged.gradle.common.extensions.base.WithEnabledProperty;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.Configurations;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.IDE;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.Runs;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.SourceSets;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.ide.IDEA;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.runs.DevLogin;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.runs.RenderDoc;
import org.gradle.api.Project;

public abstract class ConventionsExtension
extends WithEnabledProperty
implements BaseDSLElement<Conventions>,
Conventions {
    private final Configurations configurations;
    private final SourceSets sourceSets;
    private final IDE ide;
    private final Runs runs;

    @Inject
    public ConventionsExtension(Project project) {
        super(project, "conventions");
        this.configurations = (Configurations)project.getObjects().newInstance(ConfigurationsExtension.class, new Object[]{this});
        this.sourceSets = (SourceSets)project.getObjects().newInstance(SourceSetsExtension.class, new Object[]{this});
        this.ide = (IDE)project.getObjects().newInstance(IDEExtension.class, new Object[]{this});
        this.runs = (Runs)project.getObjects().newInstance(RunsExtension.class, new Object[]{this});
    }

    public Configurations getConfigurations() {
        return this.configurations;
    }

    public SourceSets getSourceSets() {
        return this.sourceSets;
    }

    public IDE getIde() {
        return this.ide;
    }

    public Runs getRuns() {
        return this.runs;
    }

    public static abstract class ConfigurationsExtension
    extends WithEnabledProperty
    implements BaseDSLElement<Configurations>,
    Configurations {
        @Inject
        public ConfigurationsExtension(WithEnabledProperty parent) {
            super(parent, "configurations");
            this.getLocalRuntimeConfigurationPostFix().convention(this.getStringProperty("localRuntimeConfigurationPostFix", "LocalRuntime"));
            this.getRunRuntimeConfigurationPostFix().convention(this.getStringProperty("perSourceSetRunRuntimeConfigurationPostFix", "LocalRunRuntime"));
            this.getPerRunRuntimeConfigurationPostFix().convention(this.getStringProperty("perRunRuntimeConfigurationPostFix", "Run"));
            this.getRunRuntimeConfigurationName().convention(this.getStringProperty("runRuntimeConfigurationName", "runs"));
        }
    }

    public static abstract class SourceSetsExtension
    extends WithEnabledProperty
    implements BaseDSLElement<SourceSets>,
    SourceSets {
        @Inject
        public SourceSetsExtension(WithEnabledProperty parent) {
            super(parent, "sourcesets");
            this.getShouldMainSourceSetBeAutomaticallyAddedToRuns().convention(this.getBooleanProperty("automatic-inclusion", true, false));
            this.getShouldTestSourceSetBeAutomaticallyAddedToRuns().convention(this.getBooleanProperty("automatic-inclusion-test", false, false));
            this.getShouldSourceSetsLocalRunRuntimesBeAutomaticallyAddedToRuns().convention(this.getBooleanProperty("automatic-inclusion-local-run-runtime", true, false));
        }
    }

    public static abstract class IDEExtension
    extends WithEnabledProperty
    implements BaseDSLElement<IDE>,
    IDE {
        private final IDEA idea = (IDEA)this.getProject().getObjects().newInstance(IDEAExtension.class, new Object[]{this});

        @Inject
        public IDEExtension(WithEnabledProperty parent) {
            super(parent, "ide");
        }

        public IDEA getIdea() {
            return this.idea;
        }
    }

    public static abstract class RunsExtension
    extends WithEnabledProperty
    implements BaseDSLElement<Runs>,
    Runs {
        private final DevLogin devLogin = (DevLogin)this.getProject().getObjects().newInstance(DevLoginExtension.class, new Object[]{this});
        private final RenderDoc renderDoc = (RenderDoc)this.getProject().getObjects().newInstance(RenderDocExtension.class, new Object[]{this});

        @Inject
        public RunsExtension(WithEnabledProperty parent) {
            super(parent, "runs");
            this.getShouldDefaultRunsBeCreated().convention(this.getBooleanProperty("create-default-run-per-type", true, false));
            this.getShouldDefaultTestTaskBeReused().convention(this.getBooleanProperty("reuse-default-test-task", false, false));
        }

        public DevLogin getDevLogin() {
            return this.devLogin;
        }

        public RenderDoc getRenderDoc() {
            return this.renderDoc;
        }
    }

    public static abstract class IDEAExtension
    extends WithEnabledProperty
    implements BaseDSLElement<IDEA>,
    IDEA {
        @Inject
        public IDEAExtension(WithEnabledProperty parent) {
            super(parent, "idea");
            this.getShouldUseCompilerDetection().convention(this.getBooleanProperty("compiler-detection", true, false));
            this.getShouldUsePostSyncTask().convention(this.getBooleanProperty("use-post-sync-task", false, false));
            this.getShouldReconfigureTemplatesForTests().convention(this.getBooleanProperty("reconfigure-unit-test-templates", false, false));
            this.getShouldUseArgsFile().convention(this.getBooleanProperty("use-args-file", true, true));
        }
    }

    public static abstract class RenderDocExtension
    extends WithEnabledProperty
    implements BaseDSLElement<RenderDoc>,
    RenderDoc {
        @Inject
        public RenderDocExtension(WithEnabledProperty parent) {
            super(parent, "renderdoc");
            this.getConventionForRun().convention(this.getBooleanProperty("conventionForRun", false, false));
        }
    }

    public static abstract class DevLoginExtension
    extends WithEnabledProperty
    implements BaseDSLElement<DevLogin>,
    DevLogin {
        @Inject
        public DevLoginExtension(WithEnabledProperty parent) {
            super(parent, "devlogin");
            this.getConventionForRun().convention(this.getBooleanProperty("conventionForRun", false, false));
        }
    }
}

