/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.dependency.replacement;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.extensions.dependency.replacement.Context;
import net.neoforged.gradle.common.extensions.dependency.replacement.Handler;
import net.neoforged.gradle.common.extensions.dependency.replacement.RepoEntryDefinition;
import net.neoforged.gradle.common.tasks.ArtifactFromOutput;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementHandler;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacer;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.ReplacementAware;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.ReplacementResult;
import net.neoforged.gradle.dsl.common.extensions.repository.Entry;
import net.neoforged.gradle.dsl.common.extensions.repository.EntryDefinition;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ReplacementLogic
implements ConfigurableDSLElement<DependencyReplacement>,
DependencyReplacement {
    private final Project project;
    private final Table<Dependency, Configuration, Optional<ReplacementResult>> dependencyReplacementInformation = HashBasedTable.create();
    private final Table<Dependency, ReplacementResult, Entry> repositoryEntries = HashBasedTable.create();
    private final Map<Dependency, Dependency> originalDependencyLookup = new ConcurrentHashMap<Dependency, Dependency>();
    private final NamedDomainObjectContainer<DependencyReplacementHandler> dependencyReplacementHandlers;
    private final List<DependencyReplacement.DependencyReplacedCallback> whenDependencyReplaced = new ArrayList<DependencyReplacement.DependencyReplacedCallback>();

    @Inject
    public ReplacementLogic(Project project) {
        this.project = project;
        this.dependencyReplacementHandlers = this.project.getObjects().domainObjectContainer(DependencyReplacementHandler.class, name -> (DependencyReplacementHandler)this.project.getObjects().newInstance(Handler.class, new Object[]{this.project, name}));
        this.project.getConfigurations().configureEach(this::handleConfiguration);
    }

    public void whenDependencyReplaced(DependencyReplacement.DependencyReplacedCallback dependencyAction) {
        this.whenDependencyReplaced.add(dependencyAction);
        this.originalDependencyLookup.forEach((arg_0, arg_1) -> ((DependencyReplacement.DependencyReplacedCallback)dependencyAction).apply(arg_0, arg_1));
    }

    public void handleConfiguration(Configuration configuration) {
        configuration.getDependencies().configureEach(dependency -> {
            if (ConfigurationUtils.isUnhandledConfiguration(configuration)) {
                return;
            }
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                this.onDependencyAdded(configuration, moduleDependency);
            }
        });
        configuration.withDependencies(dependencyContainer -> {
            if (ConfigurationUtils.isUnhandledConfiguration(configuration)) {
                return;
            }
            HashSet currentDependencies = new HashSet(dependencyContainer);
            currentDependencies.forEach(dependency -> {
                if (dependency instanceof ModuleDependency) {
                    ModuleDependency moduleDependency = (ModuleDependency)dependency;
                    this.handleDependency(configuration, (DependencySet)dependencyContainer, moduleDependency);
                }
            });
        });
    }

    public Project getProject() {
        return this.project;
    }

    @NotNull
    public NamedDomainObjectContainer<DependencyReplacementHandler> getReplacementHandlers() {
        return this.dependencyReplacementHandlers;
    }

    @NotNull
    public Dependency optionallyConvertBackToOriginal(@NotNull Dependency dependency) {
        Dependency originalDependency = this.originalDependencyLookup.get(dependency);
        return Objects.requireNonNullElse(originalDependency, dependency);
    }

    private Optional<ReplacementResult> determineReplacementResult(Configuration configuration, ModuleDependency dependency) {
        Optional candidate;
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        if (repository.isDynamicDependency(dependency)) {
            candidate = Optional.empty();
            this.dependencyReplacementInformation.put((Object)dependency, (Object)configuration, candidate);
        } else if (this.dependencyReplacementInformation.contains((Object)dependency, (Object)configuration)) {
            candidate = (Optional)this.dependencyReplacementInformation.get((Object)dependency, (Object)configuration);
            if (candidate == null || candidate.isEmpty()) {
                candidate = Optional.empty();
                this.dependencyReplacementInformation.remove((Object)dependency, (Object)configuration);
            }
        } else {
            candidate = Optional.empty();
            for (DependencyReplacementHandler handler : this.getReplacementHandlers()) {
                try {
                    Optional dependencyReplacementResult = ((DependencyReplacer)handler.getReplacer().get()).get((net.neoforged.gradle.dsl.common.extensions.dependency.replacement.Context)new Context(this.project, configuration, dependency, null));
                    if (!dependencyReplacementResult.isPresent()) continue;
                    candidate = dependencyReplacementResult;
                    break;
                }
                catch (Exception exception) {
                    throw new GradleException("Uncaught exception while processing replacement of dependency " + dependency.getGroup() + ":" + dependency.getName() + " using handler " + String.valueOf(handler) + ": " + exception.getMessage(), (Throwable)exception);
                }
            }
            if (!this.dependencyReplacementInformation.contains((Object)dependency, (Object)configuration)) {
                this.dependencyReplacementInformation.put((Object)dependency, (Object)configuration, candidate);
            }
        }
        return candidate;
    }

    private void onDependencyAdded(Configuration configuration, ModuleDependency dependency) {
        Optional<ReplacementResult> candidate = this.determineReplacementResult(configuration, dependency);
        if (candidate.isPresent()) {
            ReplacementResult result = candidate.get();
            this.handleProspectiveDependencyReplacement(dependency, result, configuration);
        }
    }

    private void handleDependency(Configuration configuration, DependencySet dependencyContainer, ModuleDependency dependency) {
        Optional<ReplacementResult> candidate = this.determineReplacementResult(configuration, dependency);
        if (candidate.isPresent()) {
            ReplacementResult result = candidate.get();
            this.handleDependencyReplacement(configuration, dependencyContainer, (Dependency)dependency, result);
        }
    }

    private void handleProspectiveDependencyReplacement(ModuleDependency dependency, ReplacementResult result, Configuration target) {
        Entry newRepoEntry = this.createDummyDependency((Dependency)dependency, result);
        this.registerTasks((Dependency)dependency, result, newRepoEntry);
        this.registerSdks(result, target);
        ConfigurationUtils.findReplacementConfigurations(this.project, target);
        if (result instanceof ReplacementAware) {
            ReplacementAware replacementAware = (ReplacementAware)result;
            replacementAware.onTargetDependencyAdded();
        }
    }

    private void handleDependencyReplacement(Configuration configuration, DependencySet configuredSet, Dependency dependency, ReplacementResult result) {
        configuredSet.remove((Object)dependency);
        Entry newRepoEntry = this.createDummyDependency(dependency, result);
        TaskProvider<? extends WithOutput> rawTask = this.registerTasks(dependency, result, newRepoEntry);
        List<Configuration> targetConfigurations = ConfigurationUtils.findReplacementConfigurations(this.project, configuration);
        ConfigurableFileCollection replacedFiles = this.createDependencyFromTask(rawTask);
        Dependency replacedDependency = this.project.getDependencies().create((Object)replacedFiles);
        Dependency localRepoDependency = newRepoEntry.getDependency();
        for (Configuration targetConfiguration : targetConfigurations) {
            try {
                DependencySet targetDependencies = targetConfiguration == configuration ? configuredSet : targetConfiguration.getDependencies();
                targetDependencies.add((Object)replacedDependency);
                targetDependencies.add((Object)localRepoDependency);
            }
            catch (Exception exception) {
                throw new GradleException("Failed to add the replaced dependency to the configuration " + targetConfiguration.getName() + ": " + exception.getMessage(), (Throwable)exception);
            }
        }
        this.originalDependencyLookup.put(localRepoDependency, dependency);
        for (DependencyReplacement.DependencyReplacedCallback dependencyReplacedCallback : this.whenDependencyReplaced) {
            dependencyReplacedCallback.apply(localRepoDependency, dependency);
        }
    }

    private void registerSdks(ReplacementResult result, Configuration target) {
        List<Configuration> sdkConfigurations = ConfigurationUtils.findSdkConfigurationForSourceSetReplacement(this.project, target);
        for (Configuration sdkConfiguration : sdkConfigurations) {
            sdkConfiguration.getDependencies().addAll((Collection)result.getSdk().getAllDependencies());
        }
    }

    private TaskProvider<? extends WithOutput> registerTasks(Dependency dependency, ReplacementResult result, Entry newRepoEntry) {
        IdeManagementExtension ideManagementExtension;
        TaskProvider<? extends WithOutput> sourceTask;
        boolean requiresSourcesJar = result.getSourcesJar() != null;
        String rawArtifactSelectorName = CommonRuntimeUtils.buildTaskName((String)"selectRawArtifact", (Dependency)newRepoEntry.getDependency());
        String sourceArtifactSelectorName = requiresSourcesJar ? CommonRuntimeUtils.buildTaskName((String)"selectSourceArtifact", (Dependency)newRepoEntry.getDependency()) : null;
        boolean createsNewTasks = !this.project.getTasks().getNames().contains(rawArtifactSelectorName) || requiresSourcesJar && !this.project.getTasks().getNames().contains(sourceArtifactSelectorName);
        TaskProvider<? extends WithOutput> rawTask = this.createOrLookupRawTask(dependency, result, rawArtifactSelectorName, newRepoEntry);
        TaskProvider<? extends WithOutput> taskProvider = sourceTask = requiresSourcesJar ? this.createOrLookupSourcesTask(dependency, result, sourceArtifactSelectorName, newRepoEntry) : null;
        if (result instanceof ReplacementAware) {
            ReplacementAware replacementAware = (ReplacementAware)result;
            replacementAware.onTasksCreated(rawTask, sourceTask);
        }
        if (createsNewTasks && (ideManagementExtension = (IdeManagementExtension)this.getProject().getExtensions().getByType(IdeManagementExtension.class)).isIdeImportInProgress()) {
            ideManagementExtension.registerTaskToRun(rawTask);
            if (sourceTask != null) {
                ideManagementExtension.registerTaskToRun(sourceTask);
            }
            result.getAdditionalIdePostSyncTasks().forEach(ideManagementExtension::registerTaskToRun);
        }
        return rawTask;
    }

    private TaskProvider<? extends WithOutput> createOrLookupSourcesTask(Dependency dependency, ReplacementResult result, String sourceArtifactSelectorName, Entry newRepoEntry) {
        if (this.project.getTasks().getNames().contains(sourceArtifactSelectorName)) {
            return this.project.getTasks().named(sourceArtifactSelectorName, WithOutput.class);
        }
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        return this.project.getTasks().register(sourceArtifactSelectorName, ArtifactFromOutput.class, artifactFromOutput -> {
            artifactFromOutput.setGroup("neogradle/dependencies");
            artifactFromOutput.setDescription(String.format("Selects the source artifact from the %s dependency and puts it in the Ivy repository", dependency));
            if (result.getSourcesJar() != null) {
                artifactFromOutput.getInput().set(result.getSourcesJar().flatMap(OutputSpecification::getOutput));
            }
            artifactFromOutput.getOutput().set((Provider)repository.createOutputFor(newRepoEntry, Repository.Variant.SOURCES_CLASSIFIER));
            artifactFromOutput.dependsOn(new Object[]{result.getSourcesJar()});
        });
    }

    private TaskProvider<? extends WithOutput> createOrLookupRawTask(Dependency dependency, ReplacementResult result, String rawArtifactSelectorName, Entry newRepoEntry) {
        if (this.project.getTasks().getNames().contains(rawArtifactSelectorName)) {
            return this.project.getTasks().named(rawArtifactSelectorName, WithOutput.class);
        }
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        return this.project.getTasks().register(rawArtifactSelectorName, ArtifactFromOutput.class, artifactFromOutput -> {
            artifactFromOutput.setGroup("neogradle/dependencies");
            artifactFromOutput.setDescription(String.format("Selects the raw artifact from the %s dependency and puts it in the Ivy repository", dependency));
            artifactFromOutput.getInput().set(result.getRawJar().flatMap(OutputSpecification::getOutput));
            artifactFromOutput.getOutput().set((Provider)repository.createOutputFor(newRepoEntry, Repository.Variant.RETAINED_CLASSIFIER));
            artifactFromOutput.dependsOn(new Object[]{result.getRawJar()});
        });
    }

    @VisibleForTesting
    Entry createDummyDependency(Dependency dependency, ReplacementResult result) {
        if (!(dependency instanceof ExternalModuleDependency)) {
            throw new IllegalStateException("Only ExternalModuleDependency is supported for dependency replacement");
        }
        ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependency;
        if (this.repositoryEntries.contains((Object)dependency, (Object)result)) {
            return (Entry)this.repositoryEntries.get((Object)dependency, (Object)result);
        }
        if (result instanceof ReplacementAware) {
            ReplacementAware replacementAware = (ReplacementAware)result;
            externalModuleDependency = replacementAware.getReplacementDependency(externalModuleDependency);
        }
        Repository extension = (Repository)this.project.getExtensions().getByType(Repository.class);
        Entry entry = extension.withEntry((EntryDefinition)this.project.getObjects().newInstance(RepoEntryDefinition.class, new Object[]{this.project, externalModuleDependency, result.getDependencies(), result.getSourcesJar() != null}));
        this.repositoryEntries.put((Object)dependency, (Object)result, (Object)entry);
        return entry;
    }

    public ConfigurableFileCollection createDependencyFromTask(TaskProvider<? extends WithOutput> task) {
        return this.project.files(new Object[]{task.flatMap(OutputSpecification::getOutput)});
    }
}

