/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public abstract class AccessTransformersExtension
implements AccessTransformers {
    private final transient DependencyHandler projectDependencies;
    private final transient ArtifactHandler projectArtifacts;
    private final Project project;

    @Inject
    public AccessTransformersExtension(Project project) {
        this.project = project;
        this.projectDependencies = project.getDependencies();
        this.projectArtifacts = project.getArtifacts();
        project.afterEvaluate(p -> {
            ((Configuration)p.getConfigurations().maybeCreate("accessTransformer")).fromDependencyCollector(this.getConsume());
            ((Configuration)p.getConfigurations().maybeCreate("accessTransformerApi")).fromDependencyCollector(this.getConsumeApi());
        });
    }

    public Project getProject() {
        return this.project;
    }

    public void expose(Object path, Action<ConfigurablePublishArtifact> action) {
        this.getFiles().from(new Object[]{path});
        this.projectArtifacts.add("accessTransformerElements", path, action);
    }

    public void expose(Object path) {
        this.expose(path, (Action<ConfigurablePublishArtifact>)((Action)artifacts -> {}));
    }

    public void expose(Dependency dependency) {
        this.projectDependencies.add("accessTransformerApi", (Object)dependency);
    }
}

