/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.gradle.common.dependency.DefaultDependencyFilter;
import net.neoforged.gradle.common.dependency.DefaultDependencyVersionInformationHandler;
import net.neoforged.gradle.common.dependency.ResolvedJarJarArtifact;
import net.neoforged.gradle.common.extensions.JarJarExtension;
import net.neoforged.gradle.common.extensions.problems.IProblemReporter;
import net.neoforged.gradle.common.extensions.problems.NeoGradleProblemSpec;
import net.neoforged.gradle.dsl.common.dependency.DependencyFilter;
import net.neoforged.gradle.dsl.common.dependency.DependencyManagementObject;
import net.neoforged.gradle.dsl.common.dependency.DependencyVersionInformationHandler;
import net.neoforged.jarjar.metadata.ContainedJarIdentifier;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.jetbrains.annotations.Nullable;

public abstract class JarJarArtifacts {
    private final transient SetProperty<ResolvedComponentResult> includedRootComponents;
    private final transient SetProperty<ResolvedArtifactResult> includedArtifacts;
    private final IProblemReporter reporter;
    private final DependencyFilter dependencyFilter;
    private final DependencyVersionInformationHandler dependencyVersionInformationHandler;

    @Internal
    protected SetProperty<ResolvedComponentResult> getIncludedRootComponents() {
        return this.includedRootComponents;
    }

    @Internal
    protected SetProperty<ResolvedArtifactResult> getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Nested
    public abstract ListProperty<ResolvedJarJarArtifact> getResolvedArtifacts();

    @Nested
    public DependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    @Nested
    public DependencyVersionInformationHandler getDependencyVersionInformationHandler() {
        return this.dependencyVersionInformationHandler;
    }

    @Inject
    public JarJarArtifacts(IProblemReporter reporter) {
        this.reporter = reporter;
        this.dependencyFilter = (DependencyFilter)this.getObjectFactory().newInstance(DefaultDependencyFilter.class, new Object[0]);
        this.dependencyVersionInformationHandler = (DependencyVersionInformationHandler)this.getObjectFactory().newInstance(DefaultDependencyVersionInformationHandler.class, new Object[0]);
        this.includedRootComponents = this.getObjectFactory().setProperty(ResolvedComponentResult.class);
        this.includedArtifacts = this.getObjectFactory().setProperty(ResolvedArtifactResult.class);
        this.includedArtifacts.finalizeValueOnRead();
        this.includedRootComponents.finalizeValueOnRead();
        this.getResolvedArtifacts().finalizeValueOnRead();
        DependencyFilter filter = this.getDependencyFilter();
        DependencyVersionInformationHandler versionHandler = this.getDependencyVersionInformationHandler();
        this.getResolvedArtifacts().set(this.getIncludedRootComponents().zip(this.getIncludedArtifacts(), (components, artifacts) -> this.getIncludedJars(filter, versionHandler, (Set<ResolvedComponentResult>)components, (Set<ResolvedArtifactResult>)artifacts)));
    }

    public void configuration(Configuration jarJarConfiguration) {
        this.getIncludedArtifacts().addAll(jarJarConfiguration.getIncoming().artifactView(config -> config.attributes(attr -> attr.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar"))).getArtifacts().getResolvedArtifacts());
        this.getIncludedRootComponents().add(jarJarConfiguration.getIncoming().getResolutionResult().getRootComponent());
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        this.includedRootComponents.empty();
        this.includedArtifacts.empty();
        for (Configuration configuration : configurations) {
            this.configuration(configuration);
        }
    }

    private List<ResolvedJarJarArtifact> getIncludedJars(DependencyFilter filter, DependencyVersionInformationHandler versionHandler, Set<ResolvedComponentResult> rootComponents, Set<ResolvedArtifactResult> artifacts) {
        HashMap<ContainedJarIdentifier, String> versions = new HashMap<ContainedJarIdentifier, String>();
        HashMap<ContainedJarIdentifier, String> versionRanges = new HashMap<ContainedJarIdentifier, String>();
        HashSet<ContainedJarIdentifier> knownIdentifiers = new HashSet<ContainedJarIdentifier>();
        for (ResolvedComponentResult rootComponent : rootComponents) {
            this.collectFromComponent(rootComponent, knownIdentifiers, versions, versionRanges);
        }
        ArrayList<ResolvedJarJarArtifact> data = new ArrayList<ResolvedJarJarArtifact>();
        for (ResolvedArtifactResult result : artifacts) {
            String versionRange;
            ContainedJarIdentifier jarIdentifier;
            ResolvedVariantResult variant = result.getVariant();
            DependencyManagementObject.ArtifactIdentifier artifactIdentifier = JarJarArtifacts.capabilityOrModule(variant);
            if (artifactIdentifier == null || !filter.isIncluded(artifactIdentifier) || !knownIdentifiers.contains(jarIdentifier = new ContainedJarIdentifier(artifactIdentifier.getGroup(), artifactIdentifier.getName()))) continue;
            String version = versionHandler.getVersion(artifactIdentifier).orElse((String)versions.get(jarIdentifier));
            if (version == null) {
                version = JarJarArtifacts.getVersionFrom(variant);
            }
            if ((versionRange = versionHandler.getVersionRange(artifactIdentifier).orElse((String)versionRanges.get(jarIdentifier))) == null) {
                versionRange = JarJarArtifacts.getVersionRangeFrom(variant);
            }
            if (versionRange == null) {
                versionRange = JarJarArtifacts.makeOpenRange(variant);
            }
            if (version != null && versionRange != null) {
                data.add(new ResolvedJarJarArtifact(result.getFile(), version, versionRange, jarIdentifier.group(), jarIdentifier.artifact()));
                continue;
            }
            throw this.reporter.throwing((Action<NeoGradleProblemSpec>)((Action)spec -> spec.id("jarjar", "no-version-range").contextualLabel("Missing version range for " + jarIdentifier.group() + ":" + jarIdentifier.artifact()).solution("Ensure that the version is defined in the dependency management block or that the dependency is included in the JarJar configuration").details("The version for " + jarIdentifier.group() + ":" + jarIdentifier.artifact() + " could not be determined").section("common-jar-in-jar-publishing")));
        }
        return data.stream().sorted(Comparator.comparing(d -> d.getGroup() + ":" + d.getArtifact())).collect(Collectors.toList());
    }

    private void collectFromComponent(ResolvedComponentResult rootComponent, Set<ContainedJarIdentifier> knownIdentifiers, Map<ContainedJarIdentifier, String> versions, Map<ContainedJarIdentifier, String> versionRanges) {
        for (DependencyResult result : rootComponent.getDependencies()) {
            String originalVersion;
            String version;
            ResolvedVariantResult originalVariant;
            if (!(result instanceof ResolvedDependencyResult)) continue;
            ResolvedDependencyResult resolvedResult = (ResolvedDependencyResult)result;
            ComponentSelector requested = resolvedResult.getRequested();
            ResolvedVariantResult variant = originalVariant = resolvedResult.getResolvedVariant();
            while (variant.getExternalVariant().isPresent()) {
                variant = (ResolvedVariantResult)variant.getExternalVariant().get();
            }
            DependencyManagementObject.ArtifactIdentifier artifactIdentifier = JarJarArtifacts.capabilityOrModule(variant);
            if (artifactIdentifier == null) continue;
            ContainedJarIdentifier jarIdentifier = new ContainedJarIdentifier(artifactIdentifier.getGroup(), artifactIdentifier.getName());
            knownIdentifiers.add(jarIdentifier);
            String versionRange = JarJarArtifacts.getVersionRangeFrom(variant);
            if (versionRange == null && requested instanceof ModuleComponentSelector) {
                ModuleComponentSelector requestedModule = (ModuleComponentSelector)requested;
                if (JarJarArtifacts.isValidVersionRange(requestedModule.getVersionConstraint().getStrictVersion())) {
                    versionRange = requestedModule.getVersionConstraint().getStrictVersion();
                } else if (JarJarArtifacts.isValidVersionRange(requestedModule.getVersionConstraint().getRequiredVersion())) {
                    versionRange = requestedModule.getVersionConstraint().getRequiredVersion();
                } else if (JarJarArtifacts.isValidVersionRange(requestedModule.getVersionConstraint().getPreferredVersion())) {
                    versionRange = requestedModule.getVersionConstraint().getPreferredVersion();
                }
                if (JarJarArtifacts.isValidVersionRange(requestedModule.getVersion())) {
                    versionRange = requestedModule.getVersion();
                }
            }
            if (versionRange == null) {
                versionRange = JarJarArtifacts.makeOpenRange(variant);
            }
            if (!Objects.equals(version = JarJarArtifacts.getVersionFrom(variant), originalVersion = JarJarArtifacts.getVersionFrom(originalVariant))) {
                throw this.reporter.throwing((Action<NeoGradleProblemSpec>)((Action)spec -> spec.id("jarjar", "version-mismatch").contextualLabel("Version mismatch for " + String.valueOf(originalVariant.getOwner())).solution("Consider depending on the available-at target directly").details("Version mismatch for " + String.valueOf(originalVariant.getOwner()) + ": available-at directs to " + version + " but original is " + originalVersion + " which jarJar cannot handle well").section("common-jar-in-jar-publishing-moves-and-collisions")));
            }
            if (version != null) {
                versions.put(jarIdentifier, version);
            }
            if (versionRange == null) continue;
            versionRanges.put(jarIdentifier, versionRange);
        }
    }

    @Nullable
    private static String getVersionRangeFrom(ResolvedVariantResult variant) {
        return (String)variant.getAttributes().getAttribute(JarJarExtension.JAR_JAR_RANGE_ATTRIBUTE);
    }

    @Nullable
    private static DependencyManagementObject.ArtifactIdentifier capabilityOrModule(ResolvedVariantResult variant) {
        DependencyManagementObject.ArtifactIdentifier moduleIdentifier = null;
        if (variant.getOwner() instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)variant.getOwner();
            moduleIdentifier = new DependencyManagementObject.ArtifactIdentifier(moduleComponentIdentifier.getGroup(), moduleComponentIdentifier.getModule(), moduleComponentIdentifier.getVersion());
        }
        List capabilityIdentifiers = variant.getCapabilities().stream().map(capability -> new DependencyManagementObject.ArtifactIdentifier(capability.getGroup(), capability.getName(), capability.getVersion())).collect(Collectors.toList());
        if (moduleIdentifier != null && capabilityIdentifiers.contains(moduleIdentifier)) {
            return moduleIdentifier;
        }
        if (capabilityIdentifiers.isEmpty()) {
            return null;
        }
        return (DependencyManagementObject.ArtifactIdentifier)capabilityIdentifiers.get(0);
    }

    @Nullable
    private static String moduleOrCapabilityVersion(ResolvedVariantResult variant) {
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DependencyManagementObject.ArtifactIdentifier identifier = JarJarArtifacts.capabilityOrModule(variant);
        if (identifier != null) {
            return identifier.getVersion();
        }
        return null;
    }

    @Nullable
    private static String makeOpenRange(ResolvedVariantResult variant) {
        String baseVersion = JarJarArtifacts.moduleOrCapabilityVersion(variant);
        if (baseVersion == null) {
            return null;
        }
        return "[" + baseVersion + ",)";
    }

    @Nullable
    private static String getVersionFrom(ResolvedVariantResult variant) {
        String version = (String)variant.getAttributes().getAttribute(JarJarExtension.FIXED_JAR_JAR_VERSION_ATTRIBUTE);
        if (version == null) {
            version = JarJarArtifacts.moduleOrCapabilityVersion(variant);
        }
        return version;
    }

    private static boolean isValidVersionRange(@Nullable String range) {
        if (range == null) {
            return false;
        }
        try {
            VersionRange data = VersionRange.createFromVersionSpec((String)range);
            return data.hasRestrictions() && data.getRecommendedVersion() == null && !range.contains("+");
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }
}

