/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.dependency;

import groovy.lang.Closure;
import java.util.Objects;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.dependency.DependencyManagementObject;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDependencyManagementObject
implements DependencyManagementObject {
    @Inject
    protected abstract DependencyFactory getDependencyFactory();

    protected static DependencyManagementObject.ArtifactIdentifier createArtifactIdentifier(Dependency dependency) {
        return new DependencyManagementObject.ArtifactIdentifier(dependency.getGroup(), dependency.getName(), dependency.getVersion());
    }

    public Spec<? super DependencyManagementObject.ArtifactIdentifier> dependency(Project project) {
        return this.dependency((Dependency)this.getDependencyFactory().create(project));
    }

    public Spec<? super DependencyManagementObject.ArtifactIdentifier> dependency(CharSequence dependencyNotation) {
        return this.dependency((Dependency)this.getDependencyFactory().create(dependencyNotation));
    }

    public Spec<? super DependencyManagementObject.ArtifactIdentifier> dependency(@Nullable String group, String name, @Nullable String version) {
        return this.dependency((Dependency)this.getDependencyFactory().create(group, name, version));
    }

    public Spec<? super DependencyManagementObject.ArtifactIdentifier> dependency(Dependency dependency) {
        final DependencyManagementObject.ArtifactIdentifier identifier = AbstractDependencyManagementObject.createArtifactIdentifier(dependency);
        return this.dependency(new Closure<Boolean>(null){

            public Boolean call(Object it) {
                if (it instanceof DependencyManagementObject.ArtifactIdentifier) {
                    DependencyManagementObject.ArtifactIdentifier id = (DependencyManagementObject.ArtifactIdentifier)it;
                    return !(identifier.getGroup() != null && id.getGroup() != null && !Objects.equals(identifier.getGroup(), id.getGroup()) || identifier.getName() != null && id.getName() != null && !Objects.equals(identifier.getName(), id.getName()) || identifier.getVersion() != null && id.getVersion() != null && !Objects.equals(identifier.getVersion(), id.getVersion()));
                }
                return false;
            }
        });
    }

    public Spec<? super DependencyManagementObject.ArtifactIdentifier> dependency(Closure<Boolean> spec) {
        return Specs.convertClosureToSpec(spec);
    }
}

