/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util.run;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.extensions.NeoGradleProblemReporter;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.tasks.RenderDocDownloaderTask;
import net.neoforged.gradle.common.util.ClasspathUtils;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.DevLogin;
import net.neoforged.gradle.dsl.common.extensions.subsystems.RenderDoc;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Tools;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.Runs;
import net.neoforged.gradle.dsl.common.extensions.subsystems.tools.RenderDocTools;
import net.neoforged.gradle.dsl.common.runs.idea.extensions.IdeaRunsExtension;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunDevLoginOptions;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;

public class RunsUtil {
    @Language(value="xpath")
    public static final String IDEA_OUTPUT_XPATH = "/project/component[@name='ProjectRootManager']/output/@url";

    private RunsUtil() {
        throw new IllegalStateException("Tried to create utility class!");
    }

    public static String createTaskName(String prefix, Run run) {
        return RunsUtil.createTaskName(prefix, run.getName());
    }

    public static void configure(Project project, Run run, boolean isInternal) {
        RunsUtil.configureModSourceDefaults(project, run);
        run.configure();
        RunsUtil.setupModSources(project, run, isInternal);
        RunsUtil.configureModClasses(run);
        RunsUtil.ensureMacOsSupport(run);
        RunsUtil.setupDevLoginSupport(project, run);
        RunsUtil.setupRenderDocSupport(project, run);
        if (!isInternal) {
            RunsUtil.createTasks(project, run);
        }
        RunsUtil.registerPostSyncTasks(project, run);
    }

    public static void registerPostSyncTasks(Project project, Run run) {
        IdeManagementExtension ideManager = (IdeManagementExtension)project.getExtensions().getByType(IdeManagementExtension.class);
        ((Set)run.getPostSyncTasks().get()).forEach(ideManager::registerTaskToRun);
    }

    public static void createTasks(Project project, Run run) {
        if (!((Boolean)run.getIsJUnit().get()).booleanValue()) {
            project.getTasks().register(RunsUtil.createTaskName(run.getName()), JavaExec.class, runExec -> {
                runExec.setDescription("Runs the " + run.getName() + " run.");
                runExec.setGroup("NeoGradle/Runs");
                JavaToolchainService service = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
                runExec.getJavaLauncher().convention(service.launcherFor(((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain()));
                File workingDir = ((Directory)run.getWorkingDirectory().get()).getAsFile();
                if (!workingDir.exists()) {
                    workingDir.mkdirs();
                }
                runExec.getMainClass().convention((Provider)run.getMainClass());
                runExec.setWorkingDir(workingDir);
                runExec.args(RunsUtil.deduplicateElementsFollowingEachOther(((List)run.getArguments().get()).stream()).toList());
                runExec.jvmArgs(RunsUtil.deduplicateElementsFollowingEachOther(((List)run.getJvmArguments().get()).stream()).toList());
                runExec.systemProperties((Map)run.getSystemProperties().get());
                runExec.environment((Map)run.getEnvironmentVariables().get());
                ((Multimap)run.getModSources().all().get()).values().stream().map(SourceSet::getRuntimeClasspath).forEach(xva$0 -> runExec.classpath(new Object[]{xva$0}));
                runExec.classpath(new Object[]{run.getDependencies().getRuntimeConfiguration()});
                runExec.classpath(new Object[]{run.getRuntimeClasspath()});
                RunsUtil.updateRunExecClasspathBasedOnPrimaryTask(runExec, run);
                RunsUtil.addRunSourcesDependenciesToTask((Task)runExec, run, true);
                runExec.getDependsOn().add(run.getDependsOn());
                runExec.getDependsOn().add(run.getPostSyncTasks());
            });
        } else {
            RunsUtil.createOrReuseTestTask(project, run.getName(), run);
        }
    }

    public static void ensureMacOsSupport(Run run) {
        if (VersionJson.OS.getCurrent() == VersionJson.OS.OSX && ((Boolean)run.getIsClient().get()).booleanValue()) {
            run.getJvmArguments().add((Object)"-XstartOnFirstThread");
        }
    }

    public static void configureModSourceDefaults(Project project, Run run) {
        Conventions conventions = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getConventions();
        if (((Boolean)conventions.getSourceSets().getShouldMainSourceSetBeAutomaticallyAddedToRuns().get()).booleanValue()) {
            run.getModSources().add((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
        }
    }

    public static void setupModSources(Project project, Run run, boolean isInternal) {
        Conventions conventions = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getConventions();
        if (!isInternal && ((Boolean)conventions.getSourceSets().getShouldTestSourceSetBeAutomaticallyAddedToRuns().get()).booleanValue() && ((Boolean)run.getIsJUnit().get()).booleanValue()) {
            run.getUnitTestSources().add((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("test"));
        }
        if (((Boolean)conventions.getSourceSets().getShouldSourceSetsLocalRunRuntimesBeAutomaticallyAddedToRuns().get()).booleanValue() && ((Boolean)conventions.getConfigurations().getIsEnabled().get()).booleanValue()) {
            ((Multimap)run.getModSources().all().get()).values().forEach(sourceSet -> {
                if (project.getConfigurations().findByName(ConfigurationUtils.getSourceSetName(sourceSet, (String)conventions.getConfigurations().getRunRuntimeConfigurationPostFix().get())) != null) {
                    run.getDependencies().getRuntime().add((FileCollection)project.getConfigurations().getByName(ConfigurationUtils.getSourceSetName(sourceSet, (String)conventions.getConfigurations().getRunRuntimeConfigurationPostFix().get())));
                }
            });
        }
        if (((Multimap)run.getModSources().all().get()).isEmpty()) {
            NeoGradleProblemReporter reporter = (NeoGradleProblemReporter)project.getExtensions().getByType(NeoGradleProblemReporter.class);
            throw reporter.throwing((Action<NeoGradleProblemReporter.NeoGradleProblemSpec>)((Action)problemSpec -> problemSpec.id("runs", "noSourceSetsConfigured").contextualLabel("Run: " + run.getName()).details("The run: " + run.getName() + " has no source sets configured").solution("Please configure at least one source set").section("handling-of-none-neogradle-sibling-projects")));
        }
    }

    public static void setupDevLoginSupport(Project project, Run run) {
        DevLogin devLogin = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getDevLogin();
        Tools tools = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getTools();
        RunDevLoginOptions runsDevLogin = run.getDevLogin();
        if (((Boolean)run.getIsClient().get()).booleanValue() && ((Boolean)runsDevLogin.getIsEnabled().get()).booleanValue()) {
            String mainClass = (String)run.getMainClass().get();
            SourceSet defaultSourceSet = (SourceSet)((Map.Entry)((Multimap)run.getModSources().all().get()).entries().iterator().next()).getValue();
            String runtimeOnlyDevLoginConfigurationName = ConfigurationUtils.getSourceSetName(defaultSourceSet, (String)devLogin.getConfigurationSuffix().get());
            Configuration sourceSetRuntimeOnlyDevLoginConfiguration = (Configuration)project.getConfigurations().maybeCreate(runtimeOnlyDevLoginConfigurationName);
            Configuration sourceSetRuntimeClasspathConfiguration = (Configuration)project.getConfigurations().maybeCreate(defaultSourceSet.getRuntimeClasspathConfigurationName());
            sourceSetRuntimeClasspathConfiguration.extendsFrom(new Configuration[]{sourceSetRuntimeOnlyDevLoginConfiguration});
            sourceSetRuntimeOnlyDevLoginConfiguration.getDependencies().add((Object)project.getDependencies().create(tools.getDevLogin().get()));
            run.getArguments().add((Object)"--launch_target");
            run.getArguments().add((Object)mainClass);
            if (runsDevLogin.getProfile().isPresent()) {
                run.getArguments().add((Object)"--launch_profile");
                run.getArguments().add((Object)((String)runsDevLogin.getProfile().get()));
            }
            run.getMainClass().set((Provider)devLogin.getMainClass());
        } else if (!((Boolean)run.getIsClient().get()).booleanValue() && ((Boolean)runsDevLogin.getIsEnabled().get()).booleanValue()) {
            NeoGradleProblemReporter reporter = (NeoGradleProblemReporter)project.getExtensions().getByType(NeoGradleProblemReporter.class);
            throw reporter.throwing((Action<NeoGradleProblemReporter.NeoGradleProblemSpec>)((Action)spec -> spec.id("runs", "dev-login-not-supported").contextualLabel("Run: " + run.getName()).details("Dev login is only supported on runs which are marked as clients! The run: " + run.getName() + " is not a client run.").solution("Please mark the run as a client run or disable dev login.").section("common-runs-devlogin-configuration")));
        }
    }

    public static void setupRenderDocSupport(Project project, Run run) {
        if (((Boolean)run.getRenderDoc().getEnabled().get()).booleanValue()) {
            if (!((Boolean)run.getIsClient().get()).booleanValue()) {
                throw new InvalidUserDataException("RenderDoc can only be enabled for client runs.");
            }
            RenderDocTools renderDocTools = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getTools().getRenderDoc();
            TaskProvider setupRenderDoc = project.getTasks().register(RunsUtil.createTaskName("setupRenderDoc", run), RenderDocDownloaderTask.class, renderDoc -> {
                renderDoc.getRenderDocVersion().set((Provider)renderDocTools.getRenderDocVersion());
                renderDoc.getRenderDocOutputDirectory().set(renderDocTools.getRenderDocPath().dir("download"));
                renderDoc.getRenderDocInstallationDirectory().set(renderDocTools.getRenderDocPath().dir("installation"));
            });
            run.getDependsOn().add((Provider)setupRenderDoc);
            Configuration renderNurse = null;
            if (run.getModSources().getPrimary().isPresent()) {
                renderNurse = RunsUtil.addLocalRenderNurse((SourceSet)run.getModSources().getPrimary().get(), run);
            }
            if (renderNurse == null) {
                renderNurse = RunsUtil.registerRenderNurse(run.getProject());
            }
            run.getEnvironmentVariables().put((Object)"LD_PRELOAD", setupRenderDoc.flatMap(RenderDocDownloaderTask::getRenderDocLibraryFile).map(RegularFile::getAsFile).map(File::getAbsolutePath));
            run.getSystemProperties().put((Object)"neoforge.rendernurse.renderdoc.library", setupRenderDoc.flatMap(RenderDocDownloaderTask::getRenderDocLibraryFile).map(RegularFile::getAsFile).map(File::getAbsolutePath));
            run.getJvmArguments().add(renderNurse.getIncoming().getArtifacts().getResolvedArtifacts().map(artifactView -> (ResolvedArtifactResult)artifactView.iterator().next()).map(resolvedArtifact -> "-javaagent:%s".formatted(resolvedArtifact.getFile().getAbsolutePath())));
            run.getJvmArguments().add((Object)"--enable-preview");
            run.getJvmArguments().add((Object)"--enable-native-access=ALL-UNNAMED");
        }
    }

    private static Configuration addLocalRenderNurse(SourceSet sourceSet, Run run) {
        Project project = SourceSetUtils.getProject(sourceSet);
        Configuration renderNurse = RunsUtil.registerRenderNurse(project);
        Configuration runtimeClasspath = project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName());
        runtimeClasspath.extendsFrom(new Configuration[]{renderNurse});
        return renderNurse;
    }

    @NotNull
    private static Configuration registerRenderNurse(Project project) {
        RenderDocTools renderDocTools = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getTools().getRenderDoc();
        RenderDoc renderDocSubSystem = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getRenderDoc();
        return ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), (String)renderDocSubSystem.getConfigurationSuffix().get(), project.getDependencies().create(renderDocTools.getRenderNurse().get()));
    }

    public static void configureModClasses(Run run) {
        Provider sourceSets = run.getModSources().all().zip(run.getUnitTestSources().all(), (modSources, unitTestSources) -> {
            if (!((Boolean)run.getIsJUnit().get()).booleanValue()) {
                return modSources;
            }
            HashMultimap combined = HashMultimap.create((Multimap)modSources);
            combined.putAll(unitTestSources);
            return combined;
        });
        run.getEnvironmentVariables().put((Object)"MOD_CLASSES", RunsUtil.buildGradleModClasses((Provider<Multimap<String, SourceSet>>)sourceSets));
    }

    public static Run create(Project project, String name) {
        return (Run)project.getObjects().newInstance(RunImpl.class, new Object[]{project, name});
    }

    private static void updateRunExecClasspathBasedOnPrimaryTask(JavaExec runExec, Run run) {
        if (run.getModSources().getPrimary().isPresent()) {
            SourceSet primary = (SourceSet)run.getModSources().getPrimary().get();
            boolean primaryHasMinecraft = primary.getRuntimeClasspath().getFiles().stream().anyMatch(ClasspathUtils::isMinecraftClasspathEntry);
            FileCollection runtimeClasspathWithoutMinecraftAndWithoutPrimaryRuntimeClasspath = runExec.classpath(new Object[0]).getClasspath().filter(file -> !primary.getRuntimeClasspath().contains(file) && (!primaryHasMinecraft || !ClasspathUtils.isMinecraftClasspathEntry(file)));
            FileCollection combinedClasspath = primary.getRuntimeClasspath().plus(runtimeClasspathWithoutMinecraftAndWithoutPrimaryRuntimeClasspath);
            FileCollection fileCollection = runExec.getClasspath();
            if (fileCollection instanceof ConfigurableFileCollection) {
                ConfigurableFileCollection classpath = (ConfigurableFileCollection)fileCollection;
                classpath.setFrom((Iterable)combinedClasspath);
            } else {
                throw new IllegalStateException("Classpath is not a ConfigurableFileCollection");
            }
        }
    }

    private static void createOrReuseTestTask(Project project, String name, Run run) {
        Runs runsConventions;
        Set currentProjectsModSources = ((Multimap)run.getModSources().all().get()).values().stream().filter(sourceSet -> SourceSetUtils.getProject(sourceSet).equals(project)).collect(Collectors.toSet());
        Set currentProjectsTestSources = ((Multimap)run.getUnitTestSources().all().get()).values().stream().filter(sourceSet -> SourceSetUtils.getProject(sourceSet).equals(project)).collect(Collectors.toSet());
        if (currentProjectsModSources.size() == 1 && currentProjectsModSources.contains(((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")) && currentProjectsTestSources.size() == 1 && currentProjectsTestSources.contains(((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("test")) && ((Boolean)(runsConventions = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getConventions().getRuns()).getShouldDefaultTestTaskBeReused().get()).booleanValue()) {
            TaskProvider testTask = project.getTasks().named("test", Test.class);
            RunsUtil.configureTestTask(project, (TaskProvider<Test>)testTask, run);
            return;
        }
        RunsUtil.createNewTestTask(project, name, run);
    }

    private static void createNewTestTask(Project project, String name, Run run) {
        TaskProvider newTestTask = project.getTasks().register(RunsUtil.createTaskName("test", name), Test.class);
        RunsUtil.configureTestTask(project, (TaskProvider<Test>)newTestTask, run);
        project.getTasks().named("check", check -> check.dependsOn(new Object[]{newTestTask}));
    }

    public static String escapeAndJoin(List<String> args, String ... additional) {
        return RunsUtil.escapeStream(args, additional).collect(Collectors.joining(" "));
    }

    public static Stream<String> escapeStream(List<String> args, String ... additional) {
        return Stream.concat(args.stream(), Stream.of(additional)).map(RunsUtil::escape);
    }

    public static Stream<String> deduplicateElementsFollowingEachOther(Stream<String> stream) {
        return stream.reduce(new ArrayList(), (strings, s) -> {
            if (s.isEmpty()) {
                return strings;
            }
            if (strings.isEmpty()) {
                strings.add(s);
                return strings;
            }
            if (((String)strings.get(strings.size() - 1)).equals(s)) {
                return strings;
            }
            strings.add(s);
            return strings;
        }, (strings, strings2) -> {
            strings.addAll(strings2);
            return strings;
        }).stream();
    }

    private static String escape(String arg) {
        return RunsUtil.escapeJvmArg(arg);
    }

    public static PreparedUnitTestEnvironment prepareUnitTestEnvironment(Run run) {
        return new PreparedUnitTestEnvironment(RunsUtil.createArgsFile((Provider<RegularFile>)run.getWorkingDirectory().file("%s_test_args.txt".formatted(run.getName())), (ListProperty<String>)run.getArguments()), RunsUtil.createArgsFile((Provider<RegularFile>)run.getWorkingDirectory().file("%s_jvm_args.txt".formatted(run.getName())), (ListProperty<String>)run.getJvmArguments()));
    }

    private static File createArgsFile(Provider<RegularFile> outputFile, ListProperty<String> inputs) {
        File output = ((RegularFile)outputFile.get()).getAsFile();
        if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + output.getParentFile());
        }
        try {
            List<String> value = RunsUtil.deduplicateElementsFollowingEachOther(((List)inputs.get()).stream()).toList();
            if (output.exists()) {
                if (Files.readAllLines(output.toPath()).equals(value)) {
                    return output;
                }
                if (!output.delete()) {
                    throw new RuntimeException("Failed to delete file: " + output);
                }
            }
            Files.write(output.toPath(), value, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output;
    }

    private static void configureTestTask(Project project, TaskProvider<Test> testTaskProvider, Run run) {
        testTaskProvider.configure(testTask -> {
            PreparedUnitTestEnvironment preparedEnvironment = RunsUtil.prepareUnitTestEnvironment(run);
            RunsUtil.addRunSourcesDependenciesToTask((Task)testTask, run, true);
            testTask.getDependsOn().add(run.getDependsOn());
            testTask.getDependsOn().add(run.getPostSyncTasks());
            testTask.setWorkingDir(run.getWorkingDirectory().get());
            testTask.getSystemProperties().putAll((Map)run.getSystemProperties().get());
            testTask.getSystemProperties().put("fml.junit.argsfile", preparedEnvironment.programArgumentsFile().getAbsolutePath());
            testTask.useJUnitPlatform();
            testTask.setGroup("verification");
            testTask.systemProperties((Map)run.getSystemProperties().get());
            testTask.getEnvironment().putAll((Map)run.getEnvironmentVariables().get());
            testTask.setJvmArgs((List)run.getJvmArguments().get());
            testTask.jvmArgs(new Object[]{"@%s".formatted(preparedEnvironment.jvmArgumentsFile().getAbsolutePath())});
            ConfigurableFileCollection testCP = project.files(new Object[0]);
            testCP.from(new Object[]{run.getDependencies().getRuntimeConfiguration()});
            Stream.concat(((Multimap)run.getModSources().all().get()).values().stream(), ((Multimap)run.getUnitTestSources().all().get()).values().stream()).forEach(src -> testCP.from(new Object[]{RunsUtil.filterOutput(src)}));
            testTask.setClasspath((FileCollection)testCP);
            ConfigurableFileCollection testClassesDirs = project.files(new Object[0]);
            for (SourceSet sourceSet : ((Multimap)run.getUnitTestSources().all().get()).values()) {
                testClassesDirs.from(new Object[]{sourceSet.getOutput().getClassesDirs()});
            }
            testTask.setTestClassesDirs((FileCollection)testClassesDirs);
        });
    }

    private static FileCollection filterOutput(SourceSet srcSet) {
        FileCollection collection = srcSet.getRuntimeClasspath();
        if (srcSet.getOutput().getResourcesDir() != null) {
            File resourcesDir = srcSet.getOutput().getResourcesDir();
            collection = collection.filter(file -> !file.equals(resourcesDir));
        }
        FileCollection classesDirs = srcSet.getOutput().getClassesDirs();
        collection = collection.filter(file -> !classesDirs.contains(file));
        return collection;
    }

    public static void addRunSourcesDependenciesToTask(Task task, Run run, boolean requireCompile) {
        for (SourceSet sourceSet : ((Multimap)run.getModSources().all().get()).values()) {
            Project sourceSetProject = SourceSetUtils.getProject(sourceSet);
            task.dependsOn(new Object[]{sourceSetProject.getTasks().named(sourceSet.getProcessResourcesTaskName())});
            if (requireCompile) {
                task.dependsOn(new Object[]{sourceSetProject.getTasks().named(sourceSet.getCompileJavaTaskName())});
            }
            sourceSet.getOutput().getBuildDependencies().getDependencies(null).stream().filter(depTask -> !depTask.getName().equals(sourceSet.getCompileJavaTaskName())).filter(depTask -> !depTask.getName().equals(sourceSet.getClassesTaskName())).forEach(xva$0 -> task.dependsOn(new Object[]{xva$0}));
        }
    }

    public static Provider<String> buildGradleModClasses(Provider<Multimap<String, SourceSet>> sourceSetsProperty) {
        return RunsUtil.buildModClasses(sourceSetsProperty, sourceSet -> Stream.concat(Stream.of(sourceSet.getOutput().getResourcesDir()), sourceSet.getOutput().getClassesDirs().getFiles().stream()));
    }

    public static boolean isRunWithIdea(SourceSet sourceSet) {
        Project project = SourceSetUtils.getProject(sourceSet);
        return RunsUtil.isRunWithIdea(project);
    }

    public static boolean isRunWithIdea(Project project) {
        IdeaModel rootIdeaModel = (IdeaModel)project.getRootProject().getExtensions().getByType(IdeaModel.class);
        IdeaRunsExtension ideaRunsExtension = (IdeaRunsExtension)((ExtensionAware)rootIdeaModel.getProject()).getExtensions().getByType(IdeaRunsExtension.class);
        return (Boolean)ideaRunsExtension.getRunWithIdea().get();
    }

    public static String getIntellijModuleName(SourceSet sourceSet) {
        Project project = SourceSetUtils.getProject(sourceSet);
        StringBuilder moduleName = new StringBuilder();
        moduleName.append(project.getRootProject().getName().replace(" ", "_"));
        if (project != project.getRootProject()) {
            moduleName.append(project.getPath().replaceAll(":", "."));
        }
        moduleName.append(".");
        moduleName.append(sourceSet.getName());
        return moduleName.toString();
    }

    public static Provider<Directory> getDefaultIdeaProjectOutDirectory(Project project) {
        File ideaDir = RunsUtil.getIntellijProjectDir(project);
        if (ideaDir == null) {
            throw new IllegalStateException("Could not find IntelliJ project directory for project " + project);
        }
        File miscXml = new File(ideaDir, "misc.xml");
        String outputDirUrl = RunsUtil.evaluateXPath(miscXml, IDEA_OUTPUT_XPATH);
        if (outputDirUrl == null) {
            outputDirUrl = "file://$PROJECT_DIR$/out";
        }
        String outputDirTemplate = outputDirUrl.replaceAll("^file:", "");
        return project.getLayout().dir(project.provider(() -> new File(outputDirTemplate.replace("$PROJECT_DIR$", project.getProjectDir().getAbsolutePath()))));
    }

    @Nullable
    public static File getIntellijProjectDir(Project project) {
        Gradle root = project.getGradle().getParent();
        if (root != null) {
            while (root.getParent() != null) {
                root = root.getParent();
            }
            return RunsUtil.getIntellijProjectDir(root.getRootProject().getProjectDir());
        }
        return RunsUtil.getIntellijProjectDir(project.getRootDir());
    }

    @Nullable
    private static File getIntellijProjectDir(File gradleProjectDir) {
        File ideaDir = new File(gradleProjectDir, ".idea");
        return ideaDir.exists() ? ideaDir : null;
    }

    @Nullable
    private static String evaluateXPath(File file, @Language(value="xpath") String expression) {
        String string;
        FileInputStream fis = new FileInputStream(file);
        try {
            String result = XPathFactory.newInstance().newXPath().evaluate(expression, new InputSource(fis));
            string = result.isBlank() ? null : result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | XPathExpressionException ignored) {
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to evaluate xpath " + expression + " on file " + file, e);
            }
        }
        fis.close();
        return string;
    }

    public static Provider<Directory> getIdeaModuleOutDirectory(SourceSet sourceSet, IdeaCompileType ideaCompileType) {
        Project project = SourceSetUtils.getProject(sourceSet);
        IdeaModel ideaModel = (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
        IdeaModule ideaModule = ideaModel.getModule();
        return ideaCompileType.getSourceSetOutputDirectory(sourceSet, ideaModule);
    }

    public static Provider<? extends FileSystemLocation> getRunWithIdeaDirectory(SourceSet sourceSet, IdeaCompileType compileType, String name) {
        return RunsUtil.getIdeaModuleOutDirectory(sourceSet, compileType).map(dir -> dir.dir(name));
    }

    public static Provider<? extends FileSystemLocation> getRunWithIdeaResourcesDirectory(SourceSet sourceSet) {
        Project project = SourceSetUtils.getProject(sourceSet);
        ProjectLayout buildLayout = project.getLayout();
        return buildLayout.getBuildDirectory().map(dir -> dir.dir("idea").dir("resources").dir(sourceSet.getName()));
    }

    public static Provider<? extends FileSystemLocation> getRunWithIdeaClassesDirectory(SourceSet sourceSet, IdeaCompileType compileType) {
        return RunsUtil.getRunWithIdeaDirectory(sourceSet, compileType, "classes");
    }

    public static Provider<String> buildRunWithIdeaModClasses(Provider<Multimap<String, SourceSet>> compileSourceSets, IdeaCompileType compileType) {
        return RunsUtil.buildModClasses(compileSourceSets, sourceSet -> {
            if (RunsUtil.isRunWithIdea(sourceSet)) {
                File resourcesDir = ((FileSystemLocation)RunsUtil.getRunWithIdeaResourcesDirectory(sourceSet).get()).getAsFile();
                File classesDir = ((FileSystemLocation)RunsUtil.getRunWithIdeaClassesDirectory(sourceSet, compileType).get()).getAsFile();
                return Stream.of(resourcesDir, classesDir);
            }
            return Stream.concat(Stream.of(sourceSet.getOutput().getResourcesDir()), sourceSet.getOutput().getClassesDirs().getFiles().stream());
        });
    }

    public static Provider<String> buildRunWithEclipseModClasses(Provider<Multimap<String, SourceSet>> compileSourceSets) {
        return RunsUtil.buildModClasses(compileSourceSets, sourceSet -> {
            Project project = SourceSetUtils.getProject(sourceSet);
            EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            File conventionsDir = new File(project.getProjectDir(), "bin");
            eclipseModel.getClasspath().getBaseSourceOutputDir().convention(project.provider(() -> conventionsDir));
            File parentDir = (File)eclipseModel.getClasspath().getBaseSourceOutputDir().get();
            File sourceSetDir = new File(parentDir, sourceSet.getName());
            return Stream.of(sourceSetDir);
        });
    }

    public static Provider<String> buildModClasses(Provider<Multimap<String, SourceSet>> compileSourceSets, Function<SourceSet, Stream<File>> directoryBuilder) {
        return compileSourceSets.map(sourceSetsByRunId -> sourceSetsByRunId.entries().stream().flatMap(entry -> ((Stream)directoryBuilder.apply((SourceSet)entry.getValue())).peek(File::mkdirs).map(directory -> String.format("%s%%%%%s", entry.getKey(), directory.getAbsolutePath()))).collect(Collectors.joining(File.pathSeparator)));
    }

    private static String createTaskName(String runName) {
        return RunsUtil.createTaskName("run", runName);
    }

    private static String createTaskName(String prefix, String runName) {
        String conventionTaskName = runName.replaceAll("[^a-zA-Z0-9\\-_]", "");
        if (conventionTaskName.startsWith("run")) {
            return conventionTaskName;
        }
        return prefix + StringCapitalizationUtils.capitalize((String)conventionTaskName);
    }

    public static String escapeJvmArg(String arg) {
        String escaped = arg.replace("\\", "\\\\").replace("\"", "\\\"");
        if (escaped.contains(" ")) {
            return "\"" + escaped + "\"";
        }
        return escaped;
    }

    public record PreparedUnitTestEnvironment(File programArgumentsFile, File jvmArgumentsFile) {
    }

    public static enum IdeaCompileType {
        Production,
        Test;


        public boolean isTest() {
            return this == Test;
        }

        public File getOutputDir(IdeaModule module) {
            return this.isTest() ? module.getTestOutputDir() : module.getOutputDir();
        }

        public Provider<Directory> getSourceSetOutputDirectory(SourceSet sourceSet, IdeaModule ideaModule) {
            if (this.getOutputDir(ideaModule) != null) {
                return ideaModule.getProject().getLayout().dir(ideaModule.getProject().provider(() -> this.getOutputDir(ideaModule)));
            }
            Provider<Directory> projectOut = RunsUtil.getDefaultIdeaProjectOutDirectory(ideaModule.getProject());
            if (ideaModule.getInheritOutputDirs() == null || !ideaModule.getInheritOutputDirs().booleanValue()) {
                String sourceSetName = "main".equals(sourceSet.getName()) ? "production" : sourceSet.getName();
                return projectOut.map(dir -> dir.dir(sourceSetName));
            }
            String compileTypeDirectory = this.name().toLowerCase(Locale.ROOT);
            String moduleName = RunsUtil.getIntellijModuleName(sourceSet);
            return projectOut.map(dir -> dir.dir(compileTypeDirectory).dir(moduleName));
        }
    }
}

