/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.util.function.Supplier;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.util.ModuleDependencyUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;

public class ToolUtilities {
    private ToolUtilities() {
        throw new IllegalStateException("Tried to create utility class!");
    }

    public static File resolveTool(Project project, String tool) {
        return ToolUtilities.resolveTool(() -> (File)ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "ToolLookupFor" + ModuleDependencyUtils.toConfigurationName((String)tool), project.getDependencies().create((Object)tool)).getFiles().iterator().next());
    }

    public static ResolvedArtifact resolveToolArtifact(Project project, String tool) {
        return ToolUtilities.resolveTool(() -> (ResolvedArtifact)ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "ToolLookupFor" + ModuleDependencyUtils.toConfigurationName((String)tool), project.getDependencies().create((Object)tool)).getResolvedConfiguration().getResolvedArtifacts().iterator().next());
    }

    public static ResolvedArtifact resolveToolArtifact(Project project, Dependency tool) {
        return ToolUtilities.resolveTool(() -> (ResolvedArtifact)ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "ToolLookupFor" + ModuleDependencyUtils.toConfigurationName((Dependency)tool), tool).getResolvedConfiguration().getResolvedArtifacts().iterator().next());
    }

    private static <T> T resolveTool(Supplier<T> searcher) {
        return searcher.get();
    }
}

