/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class SerializationUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static <T> T fromJson(File file, Class<T> assetIndexClass) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Object object = GSON.fromJson((Reader)new InputStreamReader(fileInputStream), assetIndexClass);
            return (T)object;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find the file!", e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close file stream!", e);
                }
            }
        }
    }
}

