/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.internal.GUtil;

public class ConfigurationUtils {
    private static final String NEOGRADLE_RUNTIME_REPLACEMENT = "neoGradleDependencyReplacementTarget";
    private static Set<Configuration> UNHANDLED_CONFIGURATIONS = new HashSet<Configuration>();

    private ConfigurationUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ConfigurationUtils. This is a utility class");
    }

    public static Configuration temporaryConfiguration(Project project, String context, Dependency ... dependencies) {
        Configuration configuration = (Configuration)project.getConfigurations().maybeCreate("neoGradleInternal" + StringGroovyMethods.capitalize((CharSequence)context));
        if (configuration.getDependencies().isEmpty()) {
            DefaultGroovyMethods.addAll((Collection)configuration.getDependencies(), (Object[])dependencies);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            DependencyReplacement dependencyReplacement = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
            dependencyReplacement.handleConfiguration(configuration);
        }
        return configuration;
    }

    public static Configuration temporaryConfiguration(Project project, String context, Action<Configuration> processor) {
        String name = "neoGradleInternal" + StringGroovyMethods.capitalize((CharSequence)context);
        boolean exists = project.getConfigurations().getNames().contains(name);
        Configuration configuration = (Configuration)project.getConfigurations().maybeCreate("neoGradleInternal" + StringGroovyMethods.capitalize((CharSequence)context));
        if (!exists) {
            processor.execute((Object)configuration);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            DependencyReplacement dependencyReplacement = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
            dependencyReplacement.handleConfiguration(configuration);
        }
        return configuration;
    }

    public static boolean isUnhandledConfiguration(Configuration configuration) {
        return UNHANDLED_CONFIGURATIONS.contains(configuration);
    }

    public static Configuration temporaryUnhandledConfiguration(ConfigurationContainer configurations, String context, Dependency ... dependencies) {
        Configuration configuration = (Configuration)configurations.maybeCreate("neoGradleInternalUnhandled" + StringGroovyMethods.capitalize((CharSequence)context));
        UNHANDLED_CONFIGURATIONS.add(configuration);
        if (configuration.getDependencies().isEmpty()) {
            configuration.getDependencies().addAll(Arrays.asList(dependencies));
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
        }
        return configuration;
    }

    public static Configuration temporaryUnhandledConfiguration(ConfigurationContainer configurations, String context, Provider<? extends Iterable<Dependency>> dependencies) {
        String name = "neoGradleInternalUnhandled" + StringGroovyMethods.capitalize((CharSequence)context);
        if (configurations.findByName(name) != null) {
            return configurations.getByName(name);
        }
        Configuration configuration = (Configuration)configurations.create(name);
        UNHANDLED_CONFIGURATIONS.add(configuration);
        if (configuration.getDependencies().isEmpty()) {
            configuration.getDependencies().addAllLater(dependencies);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
        }
        return configuration;
    }

    public static Configuration temporaryUnhandledNotTransitiveConfiguration(ConfigurationContainer configurations, String context, Dependency ... dependencies) {
        Configuration configuration = (Configuration)configurations.maybeCreate("neoGradleInternalUnhandled" + StringGroovyMethods.capitalize((CharSequence)context));
        UNHANDLED_CONFIGURATIONS.add(configuration);
        if (configuration.getDependencies().isEmpty()) {
            DefaultGroovyMethods.addAll((Collection)configuration.getDependencies(), (Object[])dependencies);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            configuration.setTransitive(false);
        }
        return configuration;
    }

    public static Provider<File> getArtifactProvider(Project project, String context, Provider<? extends Object> dependencyNotationProvider) {
        return dependencyNotationProvider.flatMap(dependencyNotation -> {
            Configuration configuration = ConfigurationUtils.temporaryUnhandledNotTransitiveConfiguration(project.getConfigurations(), context, project.getDependencies().create(dependencyNotation));
            return configuration.getElements().map(files -> ((FileSystemLocation)files.iterator().next()).getAsFile());
        });
    }

    public static List<Configuration> findReplacementConfigurations(Project project, Configuration configuration) {
        HashSet<Configuration> resultContainer = new HashSet<Configuration>();
        resultContainer.addAll(ConfigurationUtils.findCompileOnlyConfigurationForSourceSetReplacement(project, configuration));
        resultContainer.addAll(ConfigurationUtils.findRuntimeOnlyConfigurationFromSourceSetReplacement(project, configuration));
        if (resultContainer.isEmpty()) {
            resultContainer.add(configuration);
        }
        return new ArrayList<Configuration>(resultContainer);
    }

    public static List<Configuration> findConfigurationForSourceSetReplacement(Project project, Configuration configuration, Function<SourceSet, Configuration> potentialTargetSelector, boolean requiresSuperTarget) {
        SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        ArrayList<Configuration> targets = new ArrayList<Configuration>();
        sourceSetContainer.forEach(sourceSet -> {
            Configuration target = (Configuration)potentialTargetSelector.apply((SourceSet)sourceSet);
            Configuration compileClasspath = (Configuration)project.getConfigurations().findByName(sourceSet.getCompileClasspathConfigurationName());
            if (configuration.equals(target)) {
                targets.clear();
                targets.add(target);
                return;
            }
            Set<Configuration> supers = ConfigurationUtils.getAllSuperConfigurations(compileClasspath);
            if ((!requiresSuperTarget || supers.contains(target)) && supers.contains(configuration)) {
                targets.add(target);
            }
        });
        return targets;
    }

    public static List<Configuration> findSdkConfigurationForSourceSetReplacement(Project project, Configuration configuration) {
        return ConfigurationUtils.findConfigurationForSourceSetReplacement(project, configuration, ConfigurationUtils::getSdkConfiguration, false);
    }

    public static List<Configuration> findCompileOnlyConfigurationForSourceSetReplacement(Project project, Configuration configuration) {
        return ConfigurationUtils.findConfigurationForSourceSetReplacement(project, configuration, sourceSet -> (Configuration)project.getConfigurations().findByName(sourceSet.getCompileOnlyConfigurationName()), true);
    }

    public static List<Configuration> findRuntimeOnlyConfigurationFromSourceSetReplacement(Project project, Configuration configuration) {
        SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        ArrayList<Configuration> targets = new ArrayList<Configuration>();
        sourceSetContainer.forEach(sourceSet -> {
            Configuration runtimeOnly = (Configuration)project.getConfigurations().findByName(sourceSet.getRuntimeOnlyConfigurationName());
            Configuration runtimeClasspath = (Configuration)project.getConfigurations().findByName(sourceSet.getRuntimeClasspathConfigurationName());
            if (runtimeOnly == null) {
                return;
            }
            if (configuration.equals(runtimeOnly)) {
                targets.clear();
                targets.add(runtimeOnly);
                return;
            }
            Set<Configuration> supers = ConfigurationUtils.getAllSuperConfigurations(runtimeClasspath);
            if (supers.contains(runtimeOnly) && supers.contains(configuration)) {
                Configuration reallyRuntimeOnly = (Configuration)project.getConfigurations().maybeCreate(ConfigurationUtils.getSourceSetName(sourceSet, "%s%s".formatted(NEOGRADLE_RUNTIME_REPLACEMENT, StringUtils.capitalize((String)sourceSet.getName()))));
                runtimeClasspath.extendsFrom(new Configuration[]{reallyRuntimeOnly});
                targets.add(reallyRuntimeOnly);
            }
        });
        return targets;
    }

    public static Set<Configuration> getAllSuperConfigurations(Configuration configuration) {
        HashSet<Configuration> supers = new HashSet<Configuration>();
        ConfigurationUtils.getAllSuperConfigurationsRecursive(configuration, supers);
        return supers;
    }

    private static void getAllSuperConfigurationsRecursive(Configuration configuration, Set<Configuration> supers) {
        configuration.getExtendsFrom().forEach(files -> {
            if (supers.add((Configuration)files)) {
                ConfigurationUtils.getAllSuperConfigurationsRecursive(files, supers);
            }
        });
    }

    public static String getSourceSetName(SourceSet sourceSet, String postFix) {
        String capitalized = StringGroovyMethods.capitalize((CharSequence)postFix);
        String name = sourceSet.getName().equals("main") ? "" : StringGroovyMethods.capitalize((CharSequence)sourceSet.getName());
        return StringGroovyMethods.uncapitalize((CharSequence)(name + capitalized));
    }

    public static String getRunName(Run sourceSet, String postFix) {
        String capitalized = StringGroovyMethods.capitalize((CharSequence)postFix);
        String name = StringGroovyMethods.capitalize((CharSequence)sourceSet.getName());
        return StringGroovyMethods.uncapitalize((CharSequence)(name + capitalized));
    }

    public static String configurationNameOf(SourceSet sourceSet, String baseName) {
        return StringUtils.uncapitalize((String)(ConfigurationUtils.getTaskBaseName(sourceSet) + StringUtils.capitalize((String)baseName)));
    }

    public static Configuration getSdkConfiguration(SourceSet sourceSet) {
        Project project = SourceSetUtils.getProject(sourceSet);
        Configuration configuration = (Configuration)project.getConfigurations().findByName(ConfigurationUtils.configurationNameOf(sourceSet, "sdk"));
        if (configuration == null) {
            configuration = (Configuration)project.getConfigurations().create(ConfigurationUtils.configurationNameOf(sourceSet, "sdk"));
        }
        return configuration;
    }

    public static void ensureReplacementConfigurationExists(Project project) {
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> project.getConfigurations().maybeCreate(ConfigurationUtils.getSourceSetName(sourceSet, "%s%s".formatted(NEOGRADLE_RUNTIME_REPLACEMENT, StringUtils.capitalize((String)sourceSet.getName())))));
    }

    public static String getTaskBaseName(SourceSet sourceSet) {
        return sourceSet.getName().equals("main") ? "" : GUtil.toCamelCase((CharSequence)sourceSet.getName());
    }
}

