/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class ClasspathUtils {
    private ClasspathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated.");
    }

    public static boolean isClasspathEntry(File entry) {
        return entry.getName().endsWith(".jar") || entry.getName().endsWith(".zip");
    }

    public static boolean isMinecraftClasspathEntry(File entry) {
        boolean bl;
        if (!ClasspathUtils.isClasspathEntry(entry)) {
            return false;
        }
        ZipFile zipFile = new ZipFile(entry);
        try {
            bl = zipFile.getEntry("net/minecraft/client/Minecraft.class") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return false;
            }
        }
        zipFile.close();
        return bl;
    }
}

