/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import java.io.File;
import net.neoforged.gradle.common.util.BundledServerUtils;
import net.neoforged.gradle.dsl.common.tasks.NeoGradleBase;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class UnpackBundledServer
extends NeoGradleBase
implements WithOutput {
    @TaskAction
    public void doUnpack() throws Exception {
        File serverJar = ((RegularFile)this.getServerJar().get()).getAsFile();
        File output = ((RegularFile)this.getOutput().get()).getAsFile();
        if (!BundledServerUtils.isBundledServer(serverJar)) {
            FileUtils.copyFile((File)serverJar, (File)output);
        } else {
            BundledServerUtils.extractBundledVersion(serverJar, output);
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getServerJar();
}

