/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.util.FileDownloadingUtils;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.tasks.NeoGradleBase;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class RenderDocDownloaderTask
extends NeoGradleBase {
    public RenderDocDownloaderTask() {
        this.getIsOffline().set((Object)this.getProject().getGradle().getStartParameter().isOffline());
        this.getRenderDocVersion().convention((Object)"1.33");
        this.getRenderDocOutputDirectory().convention(this.getProject().getLayout().getBuildDirectory().dir("renderdoc/download"));
        this.getRenderDocInstallationDirectory().convention(this.getProject().getLayout().getBuildDirectory().dir("renderdoc/installation"));
        this.getRenderDocLibraryFile().fileProvider(this.getRenderDocInstallationDirectory().map(dir -> this.getOSSpecificRenderDocLibraryFile(dir.getAsFile())));
        this.getOutputs().upToDateWhen(task -> false);
    }

    @TaskAction
    public void doDownload() throws IOException {
        File renderDocLibraryFile;
        File outputRoot = ((Directory)this.getRenderDocInstallationDirectory().get()).getAsFile();
        if (!outputRoot.exists() || !outputRoot.isDirectory() || !(renderDocLibraryFile = this.getOSSpecificRenderDocLibraryFile(outputRoot)).exists() || renderDocLibraryFile.isFile()) {
            // empty if block
        }
        String url = this.getOSSpecificRenderDocUrl();
        File output = ((Directory)this.getRenderDocInstallationDirectory().get()).getAsFile();
        if (output.exists()) {
            if (output.isFile()) {
                output.delete();
                output.mkdirs();
            } else {
                FileUtils.cleanDirectory((File)output);
            }
        } else {
            output.mkdirs();
        }
        FileDownloadingUtils.DownloadInfo downloadInfo = new FileDownloadingUtils.DownloadInfo(url, null, null, null, null);
        File compressedDownloadTarget = new File(((Directory)this.getRenderDocOutputDirectory().get()).getAsFile(), this.getOSSpecificFileName());
        FileDownloadingUtils.downloadTo((Boolean)this.getIsOffline().getOrElse((Object)false), downloadInfo, compressedDownloadTarget);
        this.extractOSSpecific(compressedDownloadTarget);
    }

    @Input
    @Optional
    public abstract Property<Boolean> getIsOffline();

    @Input
    public abstract Property<String> getRenderDocVersion();

    @OutputDirectory
    public abstract DirectoryProperty getRenderDocOutputDirectory();

    @Internal
    public abstract DirectoryProperty getRenderDocInstallationDirectory();

    @Internal
    public abstract RegularFileProperty getRenderDocLibraryFile();

    private File getOSSpecificRenderDocLibraryFile(File root) {
        if (VersionJson.OS.getCurrent() == VersionJson.OS.WINDOWS) {
            return new File(root, "RenderDoc_%s_64/renderdoc.dll".formatted(this.getRenderDocVersion().get()));
        }
        if (VersionJson.OS.getCurrent() == VersionJson.OS.LINUX) {
            return new File(root, "renderdoc_%s/lib/librenderdoc.so".formatted(this.getRenderDocVersion().get()));
        }
        throw new IllegalStateException("Unsupported OS: " + VersionJson.OS.getCurrent().name());
    }

    private File getOSSpecificRenderDocExecutableFile(File root) {
        if (VersionJson.OS.getCurrent() == VersionJson.OS.WINDOWS) {
            throw new IllegalStateException("Not implemented yet");
        }
        if (VersionJson.OS.getCurrent() == VersionJson.OS.LINUX) {
            return new File(root, "renderdoc_%s/bin/qrenderdoc".formatted(this.getRenderDocVersion().get()));
        }
        throw new IllegalStateException("Unsupported OS: " + VersionJson.OS.getCurrent().name());
    }

    private String getOSSpecificRenderDocUrl() {
        if (VersionJson.OS.getCurrent() == VersionJson.OS.WINDOWS) {
            return "https://renderdoc.org/stable/1.33/RenderDoc_%s_64.zip".formatted(this.getRenderDocVersion().get());
        }
        if (VersionJson.OS.getCurrent() == VersionJson.OS.LINUX) {
            return "https://renderdoc.org/stable/1.33/renderdoc_%s.tar.gz".formatted(this.getRenderDocVersion().get());
        }
        throw new IllegalStateException("Unsupported OS: " + VersionJson.OS.getCurrent().name());
    }

    private String getOSSpecificFileName() {
        if (VersionJson.OS.getCurrent() == VersionJson.OS.WINDOWS) {
            return "renderdoc.zip";
        }
        if (VersionJson.OS.getCurrent() == VersionJson.OS.LINUX) {
            return "renderdoc.tar.gz";
        }
        throw new IllegalStateException("Unsupported OS: " + VersionJson.OS.getCurrent().name());
    }

    private void extractOSSpecific(File input) {
        if (VersionJson.OS.getCurrent() == VersionJson.OS.WINDOWS) {
            this.extractWindows(input);
        } else if (VersionJson.OS.getCurrent() == VersionJson.OS.LINUX) {
            this.extractLinux(input);
        } else {
            throw new IllegalStateException("Unsupported OS: " + VersionJson.OS.getCurrent().name());
        }
    }

    private void extractWindows(File input) {
        File output = ((Directory)this.getRenderDocInstallationDirectory().get()).getAsFile();
        CopyingFileTreeVisitor visitor = new CopyingFileTreeVisitor(output.toPath());
        this.getArchiveOperations().zipTree((Object)input).visit((FileVisitor)visitor);
    }

    private void extractLinux(File input) {
        File output = ((Directory)this.getRenderDocInstallationDirectory().get()).getAsFile();
        CopyingFileTreeVisitor visitor = new CopyingFileTreeVisitor(output.toPath());
        this.getArchiveOperations().tarTree((Object)input).visit((FileVisitor)visitor);
        File executable = this.getOSSpecificRenderDocExecutableFile(output);
        executable.setExecutable(true);
    }
}

