/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import java.io.File;
import java.util.Objects;
import net.neoforged.gradle.common.tasks.DownloadingTask;
import net.neoforged.gradle.dsl.common.tasks.WithJavaVersion;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public abstract class JavaRuntimeTask
extends DownloadingTask
implements WithJavaVersion {
    public JavaRuntimeTask() {
        this.getJavaVersion().convention((Provider)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion());
        this.getJavaLauncher().convention(this.getJavaToolChain().flatMap(toolChain -> {
            if (!this.getJavaVersion().isPresent()) {
                return toolChain.launcherFor(javaToolchainSpec -> javaToolchainSpec.getLanguageVersion().set((Object)JavaLanguageVersion.of((String)Objects.requireNonNull(Jvm.current().getJavaVersion()).getMajorVersion())));
            }
            return toolChain.launcherFor(spec -> spec.getLanguageVersion().set(this.getJavaVersion()));
        }));
        this.getJavaToolChain().convention((Object)((JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class)));
    }

    @Internal
    public abstract Property<JavaToolchainService> getJavaToolChain();

    @Nested
    @Optional
    public abstract Property<JavaLanguageVersion> getJavaVersion();

    @Internal
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Internal
    public Provider<String> getExecutablePath() {
        return this.getJavaLauncher().map(JavaLauncher::getExecutablePath).map(RegularFile::getAsFile).map(File::getAbsolutePath);
    }
}

