/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.logging;

import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import org.gradle.api.Task;

public class CacheLogger {
    private final Task task;
    private final boolean debug;
    private final boolean cacheHits;

    public CacheLogger(Task task, boolean debug, boolean cacheHits) {
        this.task = task;
        this.debug = debug;
        this.cacheHits = cacheHits;
    }

    public void onCacheEquals(ICacheableJob<?, ?> stage) {
        if (this.cacheHits) {
            this.task.getLogger().lifecycle("Cache equal for task {} from {}", new Object[]{this.task.getPath(), stage.name()});
        }
    }

    public void onCacheHit(ICacheableJob<?, ?> stage) {
        if (this.cacheHits) {
            this.task.getLogger().lifecycle("Cache hit for task {} from {}", new Object[]{this.task.getPath(), stage.name()});
        }
    }

    public void onCacheMiss(ICacheableJob<?, ?> stage) {
        if (this.cacheHits) {
            this.task.getLogger().lifecycle("Cache miss for task {} from {}", new Object[]{this.task.getPath(), stage.name()});
        }
    }

    public void debug(String message) {
        if (this.debug) {
            this.task.getLogger().lifecycle(" > [" + System.currentTimeMillis() + "] (" + ProcessHandle.current().pid() + "): " + message);
        }
    }

    public void debug(String message, Exception e) {
        if (this.debug) {
            this.task.getLogger().lifecycle(" > [" + System.currentTimeMillis() + "] (" + ProcessHandle.current().pid() + "): " + message, (Throwable)e);
        }
    }
}

