/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.locking;

import java.io.File;
import net.neoforged.gradle.common.services.caching.locking.FileBasedLock;

public abstract class HealthFileUsingFileBasedLock
implements FileBasedLock {
    private final File healthyFile;
    private boolean hasFailed = true;

    public HealthFileUsingFileBasedLock(File healthyFile) {
        this.healthyFile = healthyFile;
    }

    @Override
    public boolean hasPreviousFailure() {
        return !this.healthyFile.exists();
    }

    @Override
    public void markAsSuccess() {
        this.hasFailed = false;
    }

    @Override
    public void close() throws Exception {
        if (!this.hasFailed) {
            this.healthyFile.createNewFile();
        } else if (this.healthyFile.exists() && !this.healthyFile.delete()) {
            throw new IllegalStateException("Failed to delete healthy marker file: " + this.healthyFile.getAbsolutePath());
        }
    }
}

