/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks.action;

import java.io.File;
import java.util.function.Function;
import javax.inject.Inject;
import net.neoforged.gradle.util.FileUtils;
import net.neoforged.gradle.util.GradleInternalUtils;
import org.gradle.api.Action;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;

public abstract class ExtractFileAction
implements WorkAction<Params> {
    private static final Logger LOGGER = Logging.getLogger(ExtractFileAction.class);

    @Inject
    public abstract BuildServiceRegistry getBuildServiceRegistry();

    @Inject
    public abstract ArchiveOperations getArchiveOperations();

    public void execute() {
        try {
            Params params = (Params)this.getParameters();
            File output = ((Directory)params.getOutputDirectory().get()).getAsFile();
            GradleInternalUtils.ProgressLoggerWrapper progress = GradleInternalUtils.getProgressLogger((Logger)LOGGER, (Object)this.getBuildServiceRegistry(), (String)("Extracting file: " + ((RegularFile)params.getInputFile().get()).getAsFile()));
            progress.setActionType("analyzed");
            progress.setDestFileName(output.getName());
            FileUtils.extractZip((ArchiveOperations)this.getArchiveOperations(), (File)((RegularFile)params.getInputFile().get()).getAsFile(), (File)((Directory)params.getOutputDirectory().get()).getAsFile(), (boolean)((Boolean)params.getShouldOverride().get()), (boolean)((Boolean)params.getShouldCleanTarget().get()), (Action)((Action)params.getFilter().get()), (Function)((Function)params.getRenamer().get()), (GradleInternalUtils.ProgressLoggerWrapper)progress);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Params
    extends WorkParameters {
        public RegularFileProperty getInputFile();

        public Property<Boolean> getShouldOverride();

        public Property<Boolean> getShouldCleanTarget();

        public Property<Function<String, String>> getRenamer();

        public Property<Action<? super PatternFilterable>> getFilter();

        public DirectoryProperty getOutputDirectory();
    }
}

