/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.specification;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

public abstract class CommonRuntimeSpecification
implements Specification {
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final DistributionType distribution;
    @NotNull
    private final Multimap<String, TaskTreeAdapter> preTaskTypeAdapters;
    @NotNull
    private final Multimap<String, TaskTreeAdapter> postTypeAdapters;
    @NotNull
    private final Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers;
    @NotNull
    private final CommonRuntimeExtension<?, ?, ?> runtimeExtension;

    protected CommonRuntimeSpecification(Project project, @NotNull String name, @NotNull String version, @NotNull DistributionType distribution, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers, @NotNull Class<? extends CommonRuntimeExtension<?, ?, ?>> runtimeExtensionClass) {
        this.project = project;
        this.name = name;
        this.version = version;
        this.distribution = distribution;
        this.preTaskTypeAdapters = ImmutableMultimap.copyOf(preTaskTypeAdapters);
        this.postTypeAdapters = ImmutableMultimap.copyOf(postTypeAdapters);
        this.taskCustomizers = ImmutableMultimap.copyOf(taskCustomizers);
        this.runtimeExtension = (CommonRuntimeExtension)project.getExtensions().getByType(runtimeExtensionClass);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getIdentifier() {
        return this.getName() + StringUtils.capitalize((String)this.getDistribution().getName().toLowerCase(Locale.ROOT)) + this.version;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getVersionedName() {
        Map<String, ?> runtimes = this.runtimeExtension.getDefinitions();
        if (runtimes.isEmpty()) {
            return this.getIdentifier();
        }
        if (runtimes.values().stream().noneMatch(r -> r.getSpecification().equals(this))) {
            return this.getIdentifier();
        }
        if (runtimes.size() == 1) {
            return this.getName();
        }
        return this.getIdentifier();
    }

    @NotNull
    public DistributionType getDistribution() {
        return this.distribution;
    }

    @NotNull
    public Multimap<String, TaskTreeAdapter> getPreTaskTypeAdapters() {
        return this.preTaskTypeAdapters;
    }

    @NotNull
    public Multimap<String, TaskTreeAdapter> getPostTypeAdapters() {
        return this.postTypeAdapters;
    }

    @NotNull
    public Multimap<String, TaskCustomizer<? extends Task>> getTaskCustomizers() {
        return this.taskCustomizers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommonRuntimeSpecification)) {
            return false;
        }
        CommonRuntimeSpecification that = (CommonRuntimeSpecification)o;
        if (!this.getProject().equals(that.getProject())) {
            return false;
        }
        if (!this.getIdentifier().equals(that.getIdentifier())) {
            return false;
        }
        if (this.getDistribution() != that.getDistribution()) {
            return false;
        }
        if (!this.getPreTaskTypeAdapters().equals(that.getPreTaskTypeAdapters())) {
            return false;
        }
        if (!this.getTaskCustomizers().equals(that.getTaskCustomizers())) {
            return false;
        }
        return this.getPostTypeAdapters().equals(that.getPostTypeAdapters());
    }

    public int hashCode() {
        int result = this.getProject().hashCode();
        result = 31 * result + this.getIdentifier().hashCode();
        result = 31 * result + this.getDistribution().hashCode();
        result = 31 * result + this.getPreTaskTypeAdapters().hashCode();
        result = 31 * result + this.getPostTypeAdapters().hashCode();
        result = 31 * result + this.getTaskCustomizers().hashCode();
        return result;
    }

    public String toString() {
        return "CommonSpecification{project=" + this.project + ", name='" + this.name + "', distribution=" + this.distribution + ", preTaskTypeAdapters=" + this.preTaskTypeAdapters + ", postTypeAdapters=" + this.postTypeAdapters + ", taskCustomizers=" + this.taskCustomizers + "}";
    }

    public static abstract class Builder<S extends CommonRuntimeSpecification, B extends Builder<S, B>>
    implements Specification.Builder<S, B> {
        protected final Project project;
        protected Provider<DistributionType> distributionType;
        protected boolean hasConfiguredDistributionType = false;
        protected final Multimap<String, TaskTreeAdapter> preTaskAdapters = LinkedListMultimap.create();
        protected final Multimap<String, TaskTreeAdapter> postTaskAdapters = LinkedListMultimap.create();
        protected final Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers = LinkedListMultimap.create();

        protected Builder(Project project) {
            this.project = project;
            this.configureBuilder();
        }

        protected abstract B getThis();

        protected void configureBuilder() {
        }

        @NotNull
        public Project getProject() {
            return this.project;
        }

        @NotNull
        public final B withDistributionType(Provider<DistributionType> distributionType) {
            this.distributionType = distributionType;
            this.hasConfiguredDistributionType = true;
            return this.getThis();
        }

        @NotNull
        public final B withDistributionType(DistributionType distributionType) {
            if (distributionType == null) {
                return this.getThis();
            }
            return (B)this.withDistributionType(this.project.provider(() -> distributionType));
        }

        @NotNull
        public final B withPreTaskAdapter(String taskTypeName, TaskTreeAdapter adapter) {
            this.preTaskAdapters.put((Object)taskTypeName, (Object)adapter);
            return this.getThis();
        }

        @NotNull
        public final B withPostTaskAdapter(String taskTypeName, TaskTreeAdapter adapter) {
            this.postTaskAdapters.put((Object)taskTypeName, (Object)adapter);
            return this.getThis();
        }

        @NotNull
        public final <T extends Task> B withTaskCustomizer(String taskTypeName, Class<T> taskType, Consumer<T> customizer) {
            this.taskCustomizers.put((Object)taskTypeName, (Object)new TaskCustomizer(taskType, customizer));
            return this.getThis();
        }

        @NotNull
        public abstract S build();
    }
}

