/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.naming.tasks;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.naming.renamer.ISourceRenamer;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.util.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ApplyMappingsToSourceJar
extends DefaultRuntime {
    public ApplyMappingsToSourceJar() {
        this.getRemapJavadocs().convention((Object)false);
    }

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    public final void execute() throws Throwable {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, ICacheableJob.Default.file(this.getOutput(), this::apply)).execute();
    }

    protected final void apply() throws Exception {
        ISourceRenamer renamer = (ISourceRenamer)this.getSourceRenamer().get();
        try (ZipFile zin = new ZipFile(((RegularFile)this.getInput().get()).getAsFile());
             FileOutputStream fos = new FileOutputStream(((RegularFile)this.getOutput().get()).getAsFile());
             ZipOutputStream out = new ZipOutputStream(fos);){
            Enumeration<? extends ZipEntry> entries = zin.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                out.putNextEntry(FileUtils.getStableEntry((String)entry.getName()));
                if (!entry.getName().endsWith(".java")) {
                    IOUtils.copy((InputStream)zin.getInputStream(entry), (OutputStream)out);
                } else {
                    InputStream inputStream = zin.getInputStream(entry);
                    byte[] toRemap = IOUtils.toByteArray((InputStream)inputStream);
                    inputStream.close();
                    out.write(renamer.rename(toRemap, (Boolean)this.getRemapJavadocs().getOrElse((Object)false), (Boolean)this.getRemapLambdas().getOrElse((Object)true)));
                }
                out.closeEntry();
            }
        }
        this.getLogger().debug("Applying mappings to source jar complete");
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @Input
    public abstract Property<Boolean> getRemapJavadocs();

    @Input
    public abstract Property<Boolean> getRemapLambdas();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Internal
    public abstract Property<ISourceRenamer> getSourceRenamer();
}

